<?php

namespace Api\Aramex\Location\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Fetch ServiceType
 * @subpackage Services
 */
class Fetch extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FetchCountries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Api\Aramex\Location\StructType\CountriesFetchingRequest $parameters
     * @return \Api\Aramex\Location\StructType\CountriesFetchingResponse|bool
     */
    public function FetchCountries(\Api\Aramex\Location\StructType\CountriesFetchingRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FetchCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FetchCountry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Api\Aramex\Location\StructType\CountryFetchingRequest $parameters
     * @return \Api\Aramex\Location\StructType\CountryFetchingResponse|bool
     */
    public function FetchCountry(\Api\Aramex\Location\StructType\CountryFetchingRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FetchCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FetchCities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Api\Aramex\Location\StructType\CitiesFetchingRequest $parameters
     * @return \Api\Aramex\Location\StructType\CitiesFetchingResponse|bool
     */
    public function FetchCities(\Api\Aramex\Location\StructType\CitiesFetchingRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FetchCities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FetchOffices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Api\Aramex\Location\StructType\OfficesFetchingRequest $parameters
     * @return \Api\Aramex\Location\StructType\OfficesFetchingResponse|bool
     */
    public function FetchOffices(\Api\Aramex\Location\StructType\OfficesFetchingRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FetchOffices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Api\Aramex\Location\StructType\CitiesFetchingResponse|\Api\Aramex\Location\StructType\CountriesFetchingResponse|\Api\Aramex\Location\StructType\CountryFetchingResponse|\Api\Aramex\Location\StructType\OfficesFetchingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
