<?php

namespace Api\Aramex\Location\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOffice ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOffice
 * @subpackage Arrays
 */
class ArrayOfOffice extends AbstractStructArrayBase
{
    /**
     * The Office
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Location\StructType\Office[]
     */
    public $Office;
    /**
     * Constructor method for ArrayOfOffice
     * @uses ArrayOfOffice::setOffice()
     * @param \Api\Aramex\Location\StructType\Office[] $office
     */
    public function __construct(array $office = array())
    {
        $this
            ->setOffice($office);
    }
    /**
     * Get Office value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Location\StructType\Office[]|null
     */
    public function getOffice()
    {
        return isset($this->Office) ? $this->Office : null;
    }
    /**
     * Set Office value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Location\StructType\Office[] $office
     * @return \Api\Aramex\Location\ArrayType\ArrayOfOffice
     */
    public function setOffice(array $office = array())
    {
        foreach ($office as $arrayOfOfficeOfficeItem) {
            // validation for constraint: itemType
            if (!$arrayOfOfficeOfficeItem instanceof \Api\Aramex\Location\StructType\Office) {
                throw new \InvalidArgumentException(sprintf('The Office property can only contain items of \Api\Aramex\Location\StructType\Office, "%s" given', is_object($arrayOfOfficeOfficeItem) ? get_class($arrayOfOfficeOfficeItem) : gettype($arrayOfOfficeOfficeItem)), __LINE__);
            }
        }
        if (is_null($office) || (is_array($office) && empty($office))) {
            unset($this->Office);
        } else {
            $this->Office = $office;
        }
        return $this;
    }
    /**
     * Add item to Office value
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Location\StructType\Office $item
     * @return \Api\Aramex\Location\ArrayType\ArrayOfOffice
     */
    public function addToOffice(\Api\Aramex\Location\StructType\Office $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Api\Aramex\Location\StructType\Office) {
            throw new \InvalidArgumentException(sprintf('The Office property can only contain items of \Api\Aramex\Location\StructType\Office, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Office[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Api\Aramex\Location\StructType\Office|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Api\Aramex\Location\StructType\Office|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Api\Aramex\Location\StructType\Office|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Api\Aramex\Location\StructType\Office|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Api\Aramex\Location\StructType\Office|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Office
     */
    public function getAttributeName()
    {
        return 'Office';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Location\ArrayType\ArrayOfOffice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
