<?php

namespace Api\Aramex\Location\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCountry ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCountry
 * @subpackage Arrays
 */
class ArrayOfCountry extends AbstractStructArrayBase
{
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Location\StructType\Country[]
     */
    public $Country;
    /**
     * Constructor method for ArrayOfCountry
     * @uses ArrayOfCountry::setCountry()
     * @param \Api\Aramex\Location\StructType\Country[] $country
     */
    public function __construct(array $country = array())
    {
        $this
            ->setCountry($country);
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Location\StructType\Country[]|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Location\StructType\Country[] $country
     * @return \Api\Aramex\Location\ArrayType\ArrayOfCountry
     */
    public function setCountry(array $country = array())
    {
        foreach ($country as $arrayOfCountryCountryItem) {
            // validation for constraint: itemType
            if (!$arrayOfCountryCountryItem instanceof \Api\Aramex\Location\StructType\Country) {
                throw new \InvalidArgumentException(sprintf('The Country property can only contain items of \Api\Aramex\Location\StructType\Country, "%s" given', is_object($arrayOfCountryCountryItem) ? get_class($arrayOfCountryCountryItem) : gettype($arrayOfCountryCountryItem)), __LINE__);
            }
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Add item to Country value
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Location\StructType\Country $item
     * @return \Api\Aramex\Location\ArrayType\ArrayOfCountry
     */
    public function addToCountry(\Api\Aramex\Location\StructType\Country $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Api\Aramex\Location\StructType\Country) {
            throw new \InvalidArgumentException(sprintf('The Country property can only contain items of \Api\Aramex\Location\StructType\Country, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Country[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Api\Aramex\Location\StructType\Country|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Api\Aramex\Location\StructType\Country|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Api\Aramex\Location\StructType\Country|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Api\Aramex\Location\StructType\Country|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Api\Aramex\Location\StructType\Country|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Country
     */
    public function getAttributeName()
    {
        return 'Country';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Location\ArrayType\ArrayOfCountry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
