<?php

namespace Api\Aramex\Location\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAddress ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAddress
 * @subpackage Arrays
 */
class ArrayOfAddress extends AbstractStructArrayBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Location\StructType\Address[]
     */
    public $Address;
    /**
     * Constructor method for ArrayOfAddress
     * @uses ArrayOfAddress::setAddress()
     * @param \Api\Aramex\Location\StructType\Address[] $address
     */
    public function __construct(array $address = array())
    {
        $this
            ->setAddress($address);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Location\StructType\Address[]|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Location\StructType\Address[] $address
     * @return \Api\Aramex\Location\ArrayType\ArrayOfAddress
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $arrayOfAddressAddressItem) {
            // validation for constraint: itemType
            if (!$arrayOfAddressAddressItem instanceof \Api\Aramex\Location\StructType\Address) {
                throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \Api\Aramex\Location\StructType\Address, "%s" given', is_object($arrayOfAddressAddressItem) ? get_class($arrayOfAddressAddressItem) : gettype($arrayOfAddressAddressItem)), __LINE__);
            }
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Location\StructType\Address $item
     * @return \Api\Aramex\Location\ArrayType\ArrayOfAddress
     */
    public function addToAddress(\Api\Aramex\Location\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Api\Aramex\Location\StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \Api\Aramex\Location\StructType\Address, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Api\Aramex\Location\StructType\Address|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Api\Aramex\Location\StructType\Address|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Api\Aramex\Location\StructType\Address|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Api\Aramex\Location\StructType\Address|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Api\Aramex\Location\StructType\Address|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Address
     */
    public function getAttributeName()
    {
        return 'Address';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Location\ArrayType\ArrayOfAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
