<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Informacion ServiceType
 * @subpackage Services
 */
class Informacion extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InformacionInscripcion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InformacionInscripcion $parameters
     * @return \StructType\InformacionInscripcionResponse|bool
     */
    public function InformacionInscripcion(\StructType\InformacionInscripcion $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InformacionInscripcion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InformacionInscripcionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
