<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consulta ServiceType
 * @subpackage Services
 */
class Consulta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultaDeCampanas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaDeCampanas $parameters
     * @return \StructType\ConsultaDeCampanasResponse|bool
     */
    public function ConsultaDeCampanas(\StructType\ConsultaDeCampanas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConsultaDeCampanas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaDeOfertas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaDeOfertas $parameters
     * @return \StructType\ConsultaDeOfertasResponse|bool
     */
    public function ConsultaDeOfertas(\StructType\ConsultaDeOfertas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConsultaDeOfertas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConsultaDeCampanasResponse|\StructType\ConsultaDeOfertasResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
