<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Respuesta StructType
 * @subpackage Structs
 */
class Respuesta extends AbstractStructBase
{
    /**
     * The Codigo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Codigo;
    /**
     * The Estado
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Estado;
    /**
     * The Descripcion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Descripcion;
    /**
     * The Fecha
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fecha;
    /**
     * The CodigoPromocional
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoPromocional;
    /**
     * Constructor method for Respuesta
     * @uses Respuesta::setCodigo()
     * @uses Respuesta::setEstado()
     * @uses Respuesta::setDescripcion()
     * @uses Respuesta::setFecha()
     * @uses Respuesta::setCodigoPromocional()
     * @param int $codigo
     * @param int $estado
     * @param string $descripcion
     * @param string $fecha
     * @param string $codigoPromocional
     */
    public function __construct($codigo = null, $estado = null, $descripcion = null, $fecha = null, $codigoPromocional = null)
    {
        $this
            ->setCodigo($codigo)
            ->setEstado($estado)
            ->setDescripcion($descripcion)
            ->setFecha($fecha)
            ->setCodigoPromocional($codigoPromocional);
    }
    /**
     * Get Codigo value
     * @return int
     */
    public function getCodigo()
    {
        return $this->Codigo;
    }
    /**
     * Set Codigo value
     * @param int $codigo
     * @return \StructType\Respuesta
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !is_numeric($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigo)), __LINE__);
        }
        $this->Codigo = $codigo;
        return $this;
    }
    /**
     * Get Estado value
     * @return int
     */
    public function getEstado()
    {
        return $this->Estado;
    }
    /**
     * Set Estado value
     * @param int $estado
     * @return \StructType\Respuesta
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: int
        if (!is_null($estado) && !is_numeric($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($estado)), __LINE__);
        }
        $this->Estado = $estado;
        return $this;
    }
    /**
     * Get Descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->Descripcion;
    }
    /**
     * Set Descripcion value
     * @param string $descripcion
     * @return \StructType\Respuesta
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descripcion)), __LINE__);
        }
        $this->Descripcion = $descripcion;
        return $this;
    }
    /**
     * Get Fecha value
     * @return string|null
     */
    public function getFecha()
    {
        return $this->Fecha;
    }
    /**
     * Set Fecha value
     * @param string $fecha
     * @return \StructType\Respuesta
     */
    public function setFecha($fecha = null)
    {
        // validation for constraint: string
        if (!is_null($fecha) && !is_string($fecha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fecha)), __LINE__);
        }
        $this->Fecha = $fecha;
        return $this;
    }
    /**
     * Get CodigoPromocional value
     * @return string|null
     */
    public function getCodigoPromocional()
    {
        return $this->CodigoPromocional;
    }
    /**
     * Set CodigoPromocional value
     * @param string $codigoPromocional
     * @return \StructType\Respuesta
     */
    public function setCodigoPromocional($codigoPromocional = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPromocional) && !is_string($codigoPromocional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoPromocional)), __LINE__);
        }
        $this->CodigoPromocional = $codigoPromocional;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Respuesta
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
