<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformacionInscripcion StructType
 * @subpackage Structs
 */
class InformacionInscripcion extends AbstractStructBase
{
    /**
     * The IDCAMPANA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IDCAMPANA;
    /**
     * The IDOFERTA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IDOFERTA;
    /**
     * The USER
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $USER;
    /**
     * The PASS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PASS;
    /**
     * The RUTCLIENTE
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RUTCLIENTE;
    /**
     * Constructor method for InformacionInscripcion
     * @uses InformacionInscripcion::setIDCAMPANA()
     * @uses InformacionInscripcion::setIDOFERTA()
     * @uses InformacionInscripcion::setUSER()
     * @uses InformacionInscripcion::setPASS()
     * @uses InformacionInscripcion::setRUTCLIENTE()
     * @param int $iDCAMPANA
     * @param int $iDOFERTA
     * @param string $uSER
     * @param string $pASS
     * @param string $rUTCLIENTE
     */
    public function __construct($iDCAMPANA = null, $iDOFERTA = null, $uSER = null, $pASS = null, $rUTCLIENTE = null)
    {
        $this
            ->setIDCAMPANA($iDCAMPANA)
            ->setIDOFERTA($iDOFERTA)
            ->setUSER($uSER)
            ->setPASS($pASS)
            ->setRUTCLIENTE($rUTCLIENTE);
    }
    /**
     * Get IDCAMPANA value
     * @return int
     */
    public function getIDCAMPANA()
    {
        return $this->IDCAMPANA;
    }
    /**
     * Set IDCAMPANA value
     * @param int $iDCAMPANA
     * @return \StructType\InformacionInscripcion
     */
    public function setIDCAMPANA($iDCAMPANA = null)
    {
        // validation for constraint: int
        if (!is_null($iDCAMPANA) && !is_numeric($iDCAMPANA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDCAMPANA)), __LINE__);
        }
        $this->IDCAMPANA = $iDCAMPANA;
        return $this;
    }
    /**
     * Get IDOFERTA value
     * @return int
     */
    public function getIDOFERTA()
    {
        return $this->IDOFERTA;
    }
    /**
     * Set IDOFERTA value
     * @param int $iDOFERTA
     * @return \StructType\InformacionInscripcion
     */
    public function setIDOFERTA($iDOFERTA = null)
    {
        // validation for constraint: int
        if (!is_null($iDOFERTA) && !is_numeric($iDOFERTA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDOFERTA)), __LINE__);
        }
        $this->IDOFERTA = $iDOFERTA;
        return $this;
    }
    /**
     * Get USER value
     * @return string|null
     */
    public function getUSER()
    {
        return $this->USER;
    }
    /**
     * Set USER value
     * @param string $uSER
     * @return \StructType\InformacionInscripcion
     */
    public function setUSER($uSER = null)
    {
        // validation for constraint: string
        if (!is_null($uSER) && !is_string($uSER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uSER)), __LINE__);
        }
        $this->USER = $uSER;
        return $this;
    }
    /**
     * Get PASS value
     * @return string|null
     */
    public function getPASS()
    {
        return $this->PASS;
    }
    /**
     * Set PASS value
     * @param string $pASS
     * @return \StructType\InformacionInscripcion
     */
    public function setPASS($pASS = null)
    {
        // validation for constraint: string
        if (!is_null($pASS) && !is_string($pASS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pASS)), __LINE__);
        }
        $this->PASS = $pASS;
        return $this;
    }
    /**
     * Get RUTCLIENTE value
     * @return string|null
     */
    public function getRUTCLIENTE()
    {
        return $this->RUTCLIENTE;
    }
    /**
     * Set RUTCLIENTE value
     * @param string $rUTCLIENTE
     * @return \StructType\InformacionInscripcion
     */
    public function setRUTCLIENTE($rUTCLIENTE = null)
    {
        // validation for constraint: string
        if (!is_null($rUTCLIENTE) && !is_string($rUTCLIENTE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rUTCLIENTE)), __LINE__);
        }
        $this->RUTCLIENTE = $rUTCLIENTE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InformacionInscripcion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
