<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetalleInscripcion StructType
 * @subpackage Structs
 */
class DetalleInscripcion extends AbstractStructBase
{
    /**
     * The IDCAMPANA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IDCAMPANA;
    /**
     * The IDOFERTA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IDOFERTA;
    /**
     * The RUT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RUT;
    /**
     * The NOMBRECLIENTE
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NOMBRECLIENTE;
    /**
     * The DV
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DV;
    /**
     * The CODIGOPROMOCION
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CODIGOPROMOCION;
    /**
     * The FECHAINSCRIPCION
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FECHAINSCRIPCION;
    /**
     * Constructor method for DetalleInscripcion
     * @uses DetalleInscripcion::setIDCAMPANA()
     * @uses DetalleInscripcion::setIDOFERTA()
     * @uses DetalleInscripcion::setRUT()
     * @uses DetalleInscripcion::setNOMBRECLIENTE()
     * @uses DetalleInscripcion::setDV()
     * @uses DetalleInscripcion::setCODIGOPROMOCION()
     * @uses DetalleInscripcion::setFECHAINSCRIPCION()
     * @param int $iDCAMPANA
     * @param int $iDOFERTA
     * @param int $rUT
     * @param string $nOMBRECLIENTE
     * @param string $dV
     * @param string $cODIGOPROMOCION
     * @param string $fECHAINSCRIPCION
     */
    public function __construct($iDCAMPANA = null, $iDOFERTA = null, $rUT = null, $nOMBRECLIENTE = null, $dV = null, $cODIGOPROMOCION = null, $fECHAINSCRIPCION = null)
    {
        $this
            ->setIDCAMPANA($iDCAMPANA)
            ->setIDOFERTA($iDOFERTA)
            ->setRUT($rUT)
            ->setNOMBRECLIENTE($nOMBRECLIENTE)
            ->setDV($dV)
            ->setCODIGOPROMOCION($cODIGOPROMOCION)
            ->setFECHAINSCRIPCION($fECHAINSCRIPCION);
    }
    /**
     * Get IDCAMPANA value
     * @return int
     */
    public function getIDCAMPANA()
    {
        return $this->IDCAMPANA;
    }
    /**
     * Set IDCAMPANA value
     * @param int $iDCAMPANA
     * @return \StructType\DetalleInscripcion
     */
    public function setIDCAMPANA($iDCAMPANA = null)
    {
        // validation for constraint: int
        if (!is_null($iDCAMPANA) && !is_numeric($iDCAMPANA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDCAMPANA)), __LINE__);
        }
        $this->IDCAMPANA = $iDCAMPANA;
        return $this;
    }
    /**
     * Get IDOFERTA value
     * @return int
     */
    public function getIDOFERTA()
    {
        return $this->IDOFERTA;
    }
    /**
     * Set IDOFERTA value
     * @param int $iDOFERTA
     * @return \StructType\DetalleInscripcion
     */
    public function setIDOFERTA($iDOFERTA = null)
    {
        // validation for constraint: int
        if (!is_null($iDOFERTA) && !is_numeric($iDOFERTA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDOFERTA)), __LINE__);
        }
        $this->IDOFERTA = $iDOFERTA;
        return $this;
    }
    /**
     * Get RUT value
     * @return int
     */
    public function getRUT()
    {
        return $this->RUT;
    }
    /**
     * Set RUT value
     * @param int $rUT
     * @return \StructType\DetalleInscripcion
     */
    public function setRUT($rUT = null)
    {
        // validation for constraint: int
        if (!is_null($rUT) && !is_numeric($rUT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rUT)), __LINE__);
        }
        $this->RUT = $rUT;
        return $this;
    }
    /**
     * Get NOMBRECLIENTE value
     * @return string|null
     */
    public function getNOMBRECLIENTE()
    {
        return $this->NOMBRECLIENTE;
    }
    /**
     * Set NOMBRECLIENTE value
     * @param string $nOMBRECLIENTE
     * @return \StructType\DetalleInscripcion
     */
    public function setNOMBRECLIENTE($nOMBRECLIENTE = null)
    {
        // validation for constraint: string
        if (!is_null($nOMBRECLIENTE) && !is_string($nOMBRECLIENTE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nOMBRECLIENTE)), __LINE__);
        }
        $this->NOMBRECLIENTE = $nOMBRECLIENTE;
        return $this;
    }
    /**
     * Get DV value
     * @return string|null
     */
    public function getDV()
    {
        return $this->DV;
    }
    /**
     * Set DV value
     * @param string $dV
     * @return \StructType\DetalleInscripcion
     */
    public function setDV($dV = null)
    {
        // validation for constraint: string
        if (!is_null($dV) && !is_string($dV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dV)), __LINE__);
        }
        $this->DV = $dV;
        return $this;
    }
    /**
     * Get CODIGOPROMOCION value
     * @return string|null
     */
    public function getCODIGOPROMOCION()
    {
        return $this->CODIGOPROMOCION;
    }
    /**
     * Set CODIGOPROMOCION value
     * @param string $cODIGOPROMOCION
     * @return \StructType\DetalleInscripcion
     */
    public function setCODIGOPROMOCION($cODIGOPROMOCION = null)
    {
        // validation for constraint: string
        if (!is_null($cODIGOPROMOCION) && !is_string($cODIGOPROMOCION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cODIGOPROMOCION)), __LINE__);
        }
        $this->CODIGOPROMOCION = $cODIGOPROMOCION;
        return $this;
    }
    /**
     * Get FECHAINSCRIPCION value
     * @return string|null
     */
    public function getFECHAINSCRIPCION()
    {
        return $this->FECHAINSCRIPCION;
    }
    /**
     * Set FECHAINSCRIPCION value
     * @param string $fECHAINSCRIPCION
     * @return \StructType\DetalleInscripcion
     */
    public function setFECHAINSCRIPCION($fECHAINSCRIPCION = null)
    {
        // validation for constraint: string
        if (!is_null($fECHAINSCRIPCION) && !is_string($fECHAINSCRIPCION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fECHAINSCRIPCION)), __LINE__);
        }
        $this->FECHAINSCRIPCION = $fECHAINSCRIPCION;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DetalleInscripcion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
