<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Inscripcion ServiceType
 * @subpackage Services
 */
class Inscripcion extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Inscripcion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Inscripcion $parameters
     * @return \StructType\InscripcionResponse|bool
     */
    public function Inscripcion(\StructType\Inscripcion $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Inscripcion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InscripcionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
