<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCampana ArrayType
 * @subpackage Arrays
 */
class ArrayOfCampana extends AbstractStructArrayBase
{
    /**
     * The Campana
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Campana[]
     */
    public $Campana;
    /**
     * Constructor method for ArrayOfCampana
     * @uses ArrayOfCampana::setCampana()
     * @param \StructType\Campana[] $campana
     */
    public function __construct(array $campana = array())
    {
        $this
            ->setCampana($campana);
    }
    /**
     * Get Campana value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Campana[]|null
     */
    public function getCampana()
    {
        return isset($this->Campana) ? $this->Campana : null;
    }
    /**
     * Set Campana value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Campana[] $campana
     * @return \ArrayType\ArrayOfCampana
     */
    public function setCampana(array $campana = array())
    {
        foreach ($campana as $arrayOfCampanaCampanaItem) {
            // validation for constraint: itemType
            if (!$arrayOfCampanaCampanaItem instanceof \StructType\Campana) {
                throw new \InvalidArgumentException(sprintf('The Campana property can only contain items of \StructType\Campana, "%s" given', is_object($arrayOfCampanaCampanaItem) ? get_class($arrayOfCampanaCampanaItem) : gettype($arrayOfCampanaCampanaItem)), __LINE__);
            }
        }
        if (is_null($campana) || (is_array($campana) && empty($campana))) {
            unset($this->Campana);
        } else {
            $this->Campana = $campana;
        }
        return $this;
    }
    /**
     * Add item to Campana value
     * @throws \InvalidArgumentException
     * @param \StructType\Campana $item
     * @return \ArrayType\ArrayOfCampana
     */
    public function addToCampana(\StructType\Campana $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Campana) {
            throw new \InvalidArgumentException(sprintf('The Campana property can only contain items of \StructType\Campana, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Campana[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Campana|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Campana|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Campana|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Campana|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Campana|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Campana
     */
    public function getAttributeName()
    {
        return 'Campana';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCampana
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
