<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TNC_CancelPolicy StructType
 * @subpackage Structs
 */
class TNC_CancelPolicy extends AbstractStructBase
{
    /**
     * The ProviderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProviderId;
    /**
     * The HotelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelID;
    /**
     * The CheckIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckIn;
    /**
     * The CheckOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckOut;
    /**
     * The RatePlanID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RatePlanID;
    /**
     * The RoomTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomTypeID;
    /**
     * The RoomInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomInfo;
    /**
     * The SearchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchId;
    /**
     * Constructor method for TNC_CancelPolicy
     * @uses TNC_CancelPolicy::setProviderId()
     * @uses TNC_CancelPolicy::setHotelID()
     * @uses TNC_CancelPolicy::setCheckIn()
     * @uses TNC_CancelPolicy::setCheckOut()
     * @uses TNC_CancelPolicy::setRatePlanID()
     * @uses TNC_CancelPolicy::setRoomTypeID()
     * @uses TNC_CancelPolicy::setRoomInfo()
     * @uses TNC_CancelPolicy::setSearchId()
     * @param int $providerId
     * @param string $hotelID
     * @param string $checkIn
     * @param string $checkOut
     * @param string $ratePlanID
     * @param string $roomTypeID
     * @param string $roomInfo
     * @param string $searchId
     */
    public function __construct($providerId = null, $hotelID = null, $checkIn = null, $checkOut = null, $ratePlanID = null, $roomTypeID = null, $roomInfo = null, $searchId = null)
    {
        $this
            ->setProviderId($providerId)
            ->setHotelID($hotelID)
            ->setCheckIn($checkIn)
            ->setCheckOut($checkOut)
            ->setRatePlanID($ratePlanID)
            ->setRoomTypeID($roomTypeID)
            ->setRoomInfo($roomInfo)
            ->setSearchId($searchId);
    }
    /**
     * Get ProviderId value
     * @return int
     */
    public function getProviderId()
    {
        return $this->ProviderId;
    }
    /**
     * Set ProviderId value
     * @param int $providerId
     * @return \StructType\TNC_CancelPolicy
     */
    public function setProviderId($providerId = null)
    {
        // validation for constraint: int
        if (!is_null($providerId) && !is_numeric($providerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($providerId)), __LINE__);
        }
        $this->ProviderId = $providerId;
        return $this;
    }
    /**
     * Get HotelID value
     * @return string|null
     */
    public function getHotelID()
    {
        return $this->HotelID;
    }
    /**
     * Set HotelID value
     * @param string $hotelID
     * @return \StructType\TNC_CancelPolicy
     */
    public function setHotelID($hotelID = null)
    {
        // validation for constraint: string
        if (!is_null($hotelID) && !is_string($hotelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelID)), __LINE__);
        }
        $this->HotelID = $hotelID;
        return $this;
    }
    /**
     * Get CheckIn value
     * @return string|null
     */
    public function getCheckIn()
    {
        return $this->CheckIn;
    }
    /**
     * Set CheckIn value
     * @param string $checkIn
     * @return \StructType\TNC_CancelPolicy
     */
    public function setCheckIn($checkIn = null)
    {
        // validation for constraint: string
        if (!is_null($checkIn) && !is_string($checkIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkIn)), __LINE__);
        }
        $this->CheckIn = $checkIn;
        return $this;
    }
    /**
     * Get CheckOut value
     * @return string|null
     */
    public function getCheckOut()
    {
        return $this->CheckOut;
    }
    /**
     * Set CheckOut value
     * @param string $checkOut
     * @return \StructType\TNC_CancelPolicy
     */
    public function setCheckOut($checkOut = null)
    {
        // validation for constraint: string
        if (!is_null($checkOut) && !is_string($checkOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkOut)), __LINE__);
        }
        $this->CheckOut = $checkOut;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\TNC_CancelPolicy
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RoomTypeID value
     * @return string|null
     */
    public function getRoomTypeID()
    {
        return $this->RoomTypeID;
    }
    /**
     * Set RoomTypeID value
     * @param string $roomTypeID
     * @return \StructType\TNC_CancelPolicy
     */
    public function setRoomTypeID($roomTypeID = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeID) && !is_string($roomTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeID)), __LINE__);
        }
        $this->RoomTypeID = $roomTypeID;
        return $this;
    }
    /**
     * Get RoomInfo value
     * @return string|null
     */
    public function getRoomInfo()
    {
        return $this->RoomInfo;
    }
    /**
     * Set RoomInfo value
     * @param string $roomInfo
     * @return \StructType\TNC_CancelPolicy
     */
    public function setRoomInfo($roomInfo = null)
    {
        // validation for constraint: string
        if (!is_null($roomInfo) && !is_string($roomInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomInfo)), __LINE__);
        }
        $this->RoomInfo = $roomInfo;
        return $this;
    }
    /**
     * Get SearchId value
     * @return string|null
     */
    public function getSearchId()
    {
        return $this->SearchId;
    }
    /**
     * Set SearchId value
     * @param string $searchId
     * @return \StructType\TNC_CancelPolicy
     */
    public function setSearchId($searchId = null)
    {
        // validation for constraint: string
        if (!is_null($searchId) && !is_string($searchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchId)), __LINE__);
        }
        $this->SearchId = $searchId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TNC_CancelPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
