<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRoomDetails StructType
 * @subpackage Structs
 */
class HotelRoomDetails extends AbstractStructBase
{
    /**
     * The SearchID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchID;
    /**
     * The HotelId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelId;
    /**
     * The ProviderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProviderId;
    /**
     * Constructor method for HotelRoomDetails
     * @uses HotelRoomDetails::setSearchID()
     * @uses HotelRoomDetails::setHotelId()
     * @uses HotelRoomDetails::setProviderId()
     * @param string $searchID
     * @param string $hotelId
     * @param string $providerId
     */
    public function __construct($searchID = null, $hotelId = null, $providerId = null)
    {
        $this
            ->setSearchID($searchID)
            ->setHotelId($hotelId)
            ->setProviderId($providerId);
    }
    /**
     * Get SearchID value
     * @return string|null
     */
    public function getSearchID()
    {
        return $this->SearchID;
    }
    /**
     * Set SearchID value
     * @param string $searchID
     * @return \StructType\HotelRoomDetails
     */
    public function setSearchID($searchID = null)
    {
        // validation for constraint: string
        if (!is_null($searchID) && !is_string($searchID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchID)), __LINE__);
        }
        $this->SearchID = $searchID;
        return $this;
    }
    /**
     * Get HotelId value
     * @return string|null
     */
    public function getHotelId()
    {
        return $this->HotelId;
    }
    /**
     * Set HotelId value
     * @param string $hotelId
     * @return \StructType\HotelRoomDetails
     */
    public function setHotelId($hotelId = null)
    {
        // validation for constraint: string
        if (!is_null($hotelId) && !is_string($hotelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelId)), __LINE__);
        }
        $this->HotelId = $hotelId;
        return $this;
    }
    /**
     * Get ProviderId value
     * @return string|null
     */
    public function getProviderId()
    {
        return $this->ProviderId;
    }
    /**
     * Set ProviderId value
     * @param string $providerId
     * @return \StructType\HotelRoomDetails
     */
    public function setProviderId($providerId = null)
    {
        // validation for constraint: string
        if (!is_null($providerId) && !is_string($providerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerId)), __LINE__);
        }
        $this->ProviderId = $providerId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRoomDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
