<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelDetails StructType
 * @subpackage Structs
 */
class HotelDetails extends AbstractStructBase
{
    /**
     * The ProviderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProviderId;
    /**
     * The HotelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelID;
    /**
     * Constructor method for HotelDetails
     * @uses HotelDetails::setProviderId()
     * @uses HotelDetails::setHotelID()
     * @param int $providerId
     * @param string $hotelID
     */
    public function __construct($providerId = null, $hotelID = null)
    {
        $this
            ->setProviderId($providerId)
            ->setHotelID($hotelID);
    }
    /**
     * Get ProviderId value
     * @return int
     */
    public function getProviderId()
    {
        return $this->ProviderId;
    }
    /**
     * Set ProviderId value
     * @param int $providerId
     * @return \StructType\HotelDetails
     */
    public function setProviderId($providerId = null)
    {
        // validation for constraint: int
        if (!is_null($providerId) && !is_numeric($providerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($providerId)), __LINE__);
        }
        $this->ProviderId = $providerId;
        return $this;
    }
    /**
     * Get HotelID value
     * @return string|null
     */
    public function getHotelID()
    {
        return $this->HotelID;
    }
    /**
     * Set HotelID value
     * @param string $hotelID
     * @return \StructType\HotelDetails
     */
    public function setHotelID($hotelID = null)
    {
        // validation for constraint: string
        if (!is_null($hotelID) && !is_string($hotelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelID)), __LINE__);
        }
        $this->HotelID = $hotelID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
