<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://220.225.104.135/hotelapiservice/hotelapiws.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://220.225.104.135/hotelapiservice/hotelapiws.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Hotel ServiceType
 */
$hotel = new \ServiceType\Hotel($options);
$hotel->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for HotelSearch operation/method
 */
if ($hotel->HotelSearch(new \StructType\HotelSearch()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelDetails operation/method
 */
if ($hotel->HotelDetails(new \StructType\HotelDetails()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelRoomDetails operation/method
 */
if ($hotel->HotelRoomDetails(new \StructType\HotelRoomDetails()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Samples for Booking ServiceType
 */
$booking = new \ServiceType\Booking($options);
$booking->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for BookingTrack operation/method
 */
if ($booking->BookingTrack(new \StructType\BookingTrack()) !== false) {
    print_r($booking->getResult());
} else {
    print_r($booking->getLastError());
}
/**
 * Sample call for BookingConfirmation operation/method
 */
if ($booking->BookingConfirmation(new \StructType\BookingConfirmation()) !== false) {
    print_r($booking->getResult());
} else {
    print_r($booking->getLastError());
}
/**
 * Sample call for BookingInfo operation/method
 */
if ($booking->BookingInfo(new \StructType\BookingInfo()) !== false) {
    print_r($booking->getResult());
} else {
    print_r($booking->getLastError());
}
/**
 * Sample call for BookingDetails operation/method
 */
if ($booking->BookingDetails(new \StructType\BookingDetails()) !== false) {
    print_r($booking->getResult());
} else {
    print_r($booking->getLastError());
}
/**
 * Sample call for BookingDetails_Daywise operation/method
 */
if ($booking->BookingDetails_Daywise(new \StructType\BookingDetails_Daywise()) !== false) {
    print_r($booking->getResult());
} else {
    print_r($booking->getLastError());
}
/**
 * Samples for TNCC ServiceType
 */
$tNCC = new \ServiceType\TNCC($options);
$tNCC->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for TNC_CancelPolicy operation/method
 */
if ($tNCC->TNC_CancelPolicy(new \StructType\TNC_CancelPolicy()) !== false) {
    print_r($tNCC->getResult());
} else {
    print_r($tNCC->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
$cancel->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for CancelBooking operation/method
 */
if ($cancel->CancelBooking(new \StructType\CancelBooking()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for UpdateBookingId operation/method
 */
if ($update->UpdateBookingId(new \StructType\UpdateBookingId()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for GetCreditBalance operation/method
 */
if ($get->GetCreditBalance(new \StructType\GetCreditBalance()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCityDetails operation/method
 */
if ($get->GetCityDetails(new \StructType\GetCityDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Account ServiceType
 */
$account = new \ServiceType\Account($options);
$account->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for AccountViewDetails operation/method
 */
if ($account->AccountViewDetails(new \StructType\AccountViewDetails()) !== false) {
    print_r($account->getResult());
} else {
    print_r($account->getLastError());
}
