<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthHeader StructType
 * Meta informations extracted from the WSDL
 * - type: tns:AuthHeader
 * @subpackage Structs
 */
class AuthHeader extends AbstractStructBase
{
    /**
     * The B2BCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $B2BCode;
    /**
     * The VendorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VendorID;
    /**
     * The VendorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VendorCode;
    /**
     * Constructor method for AuthHeader
     * @uses AuthHeader::setB2BCode()
     * @uses AuthHeader::setVendorID()
     * @uses AuthHeader::setVendorCode()
     * @param string $b2BCode
     * @param string $vendorID
     * @param string $vendorCode
     */
    public function __construct($b2BCode = null, $vendorID = null, $vendorCode = null)
    {
        $this
            ->setB2BCode($b2BCode)
            ->setVendorID($vendorID)
            ->setVendorCode($vendorCode);
    }
    /**
     * Get B2BCode value
     * @return string|null
     */
    public function getB2BCode()
    {
        return $this->B2BCode;
    }
    /**
     * Set B2BCode value
     * @param string $b2BCode
     * @return \StructType\AuthHeader
     */
    public function setB2BCode($b2BCode = null)
    {
        // validation for constraint: string
        if (!is_null($b2BCode) && !is_string($b2BCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($b2BCode)), __LINE__);
        }
        $this->B2BCode = $b2BCode;
        return $this;
    }
    /**
     * Get VendorID value
     * @return string|null
     */
    public function getVendorID()
    {
        return $this->VendorID;
    }
    /**
     * Set VendorID value
     * @param string $vendorID
     * @return \StructType\AuthHeader
     */
    public function setVendorID($vendorID = null)
    {
        // validation for constraint: string
        if (!is_null($vendorID) && !is_string($vendorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorID)), __LINE__);
        }
        $this->VendorID = $vendorID;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\AuthHeader
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
