<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessPaymentResponse StructType
 * @subpackage Structs
 */
class ProcessPaymentResponse extends IntegrationApiRecordActionResponse
{
    /**
     * The PaymentState
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PaymentState;
    /**
     * The DeclineDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeclineDetails;
    /**
     * Constructor method for ProcessPaymentResponse
     * @uses ProcessPaymentResponse::setPaymentState()
     * @uses ProcessPaymentResponse::setDeclineDetails()
     * @param string $paymentState
     * @param string $declineDetails
     */
    public function __construct($paymentState = null, $declineDetails = null)
    {
        $this
            ->setPaymentState($paymentState)
            ->setDeclineDetails($declineDetails);
    }
    /**
     * Get PaymentState value
     * @return string
     */
    public function getPaymentState()
    {
        return $this->PaymentState;
    }
    /**
     * Set PaymentState value
     * @uses \EnumType\ElectronicPaymentStates::valueIsValid()
     * @uses \EnumType\ElectronicPaymentStates::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentState
     * @return \StructType\ProcessPaymentResponse
     */
    public function setPaymentState($paymentState = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ElectronicPaymentStates::valueIsValid($paymentState)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentState, implode(', ', \EnumType\ElectronicPaymentStates::getValidValues())), __LINE__);
        }
        $this->PaymentState = $paymentState;
        return $this;
    }
    /**
     * Get DeclineDetails value
     * @return string|null
     */
    public function getDeclineDetails()
    {
        return $this->DeclineDetails;
    }
    /**
     * Set DeclineDetails value
     * @param string $declineDetails
     * @return \StructType\ProcessPaymentResponse
     */
    public function setDeclineDetails($declineDetails = null)
    {
        // validation for constraint: string
        if (!is_null($declineDetails) && !is_string($declineDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($declineDetails)), __LINE__);
        }
        $this->DeclineDetails = $declineDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessPaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
