<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhoneNumberRecord StructType
 * @subpackage Structs
 */
class PhoneNumberRecord extends DataRecord
{
    /**
     * The LastCallDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastCallDate;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Contact_Id;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The ReceiveCalls
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ReceiveCalls;
    /**
     * The ReceiveSMS
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ReceiveSMS;
    /**
     * The ReceiveFaxes
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ReceiveFaxes;
    /**
     * The PhoneType_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PhoneType_Id;
    /**
     * The PhoneClass_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PhoneClass_Id;
    /**
     * The IsPreferredVoice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsPreferredVoice;
    /**
     * The IsPreferredSMS
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsPreferredSMS;
    /**
     * The IsPreferredFax
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsPreferredFax;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * Constructor method for PhoneNumberRecord
     * @uses PhoneNumberRecord::setLastCallDate()
     * @uses PhoneNumberRecord::setContact_Id()
     * @uses PhoneNumberRecord::setActive()
     * @uses PhoneNumberRecord::setReceiveCalls()
     * @uses PhoneNumberRecord::setReceiveSMS()
     * @uses PhoneNumberRecord::setReceiveFaxes()
     * @uses PhoneNumberRecord::setPhoneType_Id()
     * @uses PhoneNumberRecord::setPhoneClass_Id()
     * @uses PhoneNumberRecord::setIsPreferredVoice()
     * @uses PhoneNumberRecord::setIsPreferredSMS()
     * @uses PhoneNumberRecord::setIsPreferredFax()
     * @uses PhoneNumberRecord::setPhoneNumber()
     * @param string $lastCallDate
     * @param int $contact_Id
     * @param bool $active
     * @param bool $receiveCalls
     * @param bool $receiveSMS
     * @param bool $receiveFaxes
     * @param int $phoneType_Id
     * @param int $phoneClass_Id
     * @param bool $isPreferredVoice
     * @param bool $isPreferredSMS
     * @param bool $isPreferredFax
     * @param string $phoneNumber
     */
    public function __construct($lastCallDate = null, $contact_Id = null, $active = null, $receiveCalls = null, $receiveSMS = null, $receiveFaxes = null, $phoneType_Id = null, $phoneClass_Id = null, $isPreferredVoice = null, $isPreferredSMS = null, $isPreferredFax = null, $phoneNumber = null)
    {
        $this
            ->setLastCallDate($lastCallDate)
            ->setContact_Id($contact_Id)
            ->setActive($active)
            ->setReceiveCalls($receiveCalls)
            ->setReceiveSMS($receiveSMS)
            ->setReceiveFaxes($receiveFaxes)
            ->setPhoneType_Id($phoneType_Id)
            ->setPhoneClass_Id($phoneClass_Id)
            ->setIsPreferredVoice($isPreferredVoice)
            ->setIsPreferredSMS($isPreferredSMS)
            ->setIsPreferredFax($isPreferredFax)
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get LastCallDate value
     * @return string
     */
    public function getLastCallDate()
    {
        return $this->LastCallDate;
    }
    /**
     * Set LastCallDate value
     * @param string $lastCallDate
     * @return \StructType\PhoneNumberRecord
     */
    public function setLastCallDate($lastCallDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastCallDate) && !is_string($lastCallDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastCallDate)), __LINE__);
        }
        $this->LastCallDate = $lastCallDate;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\PhoneNumberRecord
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\PhoneNumberRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ReceiveCalls value
     * @return bool
     */
    public function getReceiveCalls()
    {
        return $this->ReceiveCalls;
    }
    /**
     * Set ReceiveCalls value
     * @param bool $receiveCalls
     * @return \StructType\PhoneNumberRecord
     */
    public function setReceiveCalls($receiveCalls = null)
    {
        // validation for constraint: boolean
        if (!is_null($receiveCalls) && !is_bool($receiveCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($receiveCalls)), __LINE__);
        }
        $this->ReceiveCalls = $receiveCalls;
        return $this;
    }
    /**
     * Get ReceiveSMS value
     * @return bool
     */
    public function getReceiveSMS()
    {
        return $this->ReceiveSMS;
    }
    /**
     * Set ReceiveSMS value
     * @param bool $receiveSMS
     * @return \StructType\PhoneNumberRecord
     */
    public function setReceiveSMS($receiveSMS = null)
    {
        // validation for constraint: boolean
        if (!is_null($receiveSMS) && !is_bool($receiveSMS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($receiveSMS)), __LINE__);
        }
        $this->ReceiveSMS = $receiveSMS;
        return $this;
    }
    /**
     * Get ReceiveFaxes value
     * @return bool
     */
    public function getReceiveFaxes()
    {
        return $this->ReceiveFaxes;
    }
    /**
     * Set ReceiveFaxes value
     * @param bool $receiveFaxes
     * @return \StructType\PhoneNumberRecord
     */
    public function setReceiveFaxes($receiveFaxes = null)
    {
        // validation for constraint: boolean
        if (!is_null($receiveFaxes) && !is_bool($receiveFaxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($receiveFaxes)), __LINE__);
        }
        $this->ReceiveFaxes = $receiveFaxes;
        return $this;
    }
    /**
     * Get PhoneType_Id value
     * @return int
     */
    public function getPhoneType_Id()
    {
        return $this->PhoneType_Id;
    }
    /**
     * Set PhoneType_Id value
     * @param int $phoneType_Id
     * @return \StructType\PhoneNumberRecord
     */
    public function setPhoneType_Id($phoneType_Id = null)
    {
        // validation for constraint: int
        if (!is_null($phoneType_Id) && !is_numeric($phoneType_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($phoneType_Id)), __LINE__);
        }
        $this->PhoneType_Id = $phoneType_Id;
        return $this;
    }
    /**
     * Get PhoneClass_Id value
     * @return int
     */
    public function getPhoneClass_Id()
    {
        return $this->PhoneClass_Id;
    }
    /**
     * Set PhoneClass_Id value
     * @param int $phoneClass_Id
     * @return \StructType\PhoneNumberRecord
     */
    public function setPhoneClass_Id($phoneClass_Id = null)
    {
        // validation for constraint: int
        if (!is_null($phoneClass_Id) && !is_numeric($phoneClass_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($phoneClass_Id)), __LINE__);
        }
        $this->PhoneClass_Id = $phoneClass_Id;
        return $this;
    }
    /**
     * Get IsPreferredVoice value
     * @return bool
     */
    public function getIsPreferredVoice()
    {
        return $this->IsPreferredVoice;
    }
    /**
     * Set IsPreferredVoice value
     * @param bool $isPreferredVoice
     * @return \StructType\PhoneNumberRecord
     */
    public function setIsPreferredVoice($isPreferredVoice = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPreferredVoice) && !is_bool($isPreferredVoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPreferredVoice)), __LINE__);
        }
        $this->IsPreferredVoice = $isPreferredVoice;
        return $this;
    }
    /**
     * Get IsPreferredSMS value
     * @return bool
     */
    public function getIsPreferredSMS()
    {
        return $this->IsPreferredSMS;
    }
    /**
     * Set IsPreferredSMS value
     * @param bool $isPreferredSMS
     * @return \StructType\PhoneNumberRecord
     */
    public function setIsPreferredSMS($isPreferredSMS = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPreferredSMS) && !is_bool($isPreferredSMS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPreferredSMS)), __LINE__);
        }
        $this->IsPreferredSMS = $isPreferredSMS;
        return $this;
    }
    /**
     * Get IsPreferredFax value
     * @return bool
     */
    public function getIsPreferredFax()
    {
        return $this->IsPreferredFax;
    }
    /**
     * Set IsPreferredFax value
     * @param bool $isPreferredFax
     * @return \StructType\PhoneNumberRecord
     */
    public function setIsPreferredFax($isPreferredFax = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPreferredFax) && !is_bool($isPreferredFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPreferredFax)), __LINE__);
        }
        $this->IsPreferredFax = $isPreferredFax;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\PhoneNumberRecord
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PhoneNumberRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
