<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagingQuery StructType
 * @subpackage Structs
 */
class PagingQuery extends WebServiceQueryBase
{
    /**
     * The PageStartFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PageStartFrom;
    /**
     * The PageSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PageSize;
    /**
     * Constructor method for PagingQuery
     * @uses PagingQuery::setPageStartFrom()
     * @uses PagingQuery::setPageSize()
     * @param int $pageStartFrom
     * @param int $pageSize
     */
    public function __construct($pageStartFrom = null, $pageSize = null)
    {
        $this
            ->setPageStartFrom($pageStartFrom)
            ->setPageSize($pageSize);
    }
    /**
     * Get PageStartFrom value
     * @return int
     */
    public function getPageStartFrom()
    {
        return $this->PageStartFrom;
    }
    /**
     * Set PageStartFrom value
     * @param int $pageStartFrom
     * @return \StructType\PagingQuery
     */
    public function setPageStartFrom($pageStartFrom = null)
    {
        // validation for constraint: int
        if (!is_null($pageStartFrom) && !is_numeric($pageStartFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageStartFrom)), __LINE__);
        }
        $this->PageStartFrom = $pageStartFrom;
        return $this;
    }
    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \StructType\PagingQuery
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !is_numeric($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PagingQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
