<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunityContactRecord StructType
 * @subpackage Structs
 */
class OpportunityContactRecord extends DataRecord
{
    /**
     * The IsPrimary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsPrimary;
    /**
     * The OpportunityContactType_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OpportunityContactType_Id;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * Constructor method for OpportunityContactRecord
     * @uses OpportunityContactRecord::setIsPrimary()
     * @uses OpportunityContactRecord::setOpportunityContactType_Id()
     * @uses OpportunityContactRecord::setContact()
     * @param bool $isPrimary
     * @param int $opportunityContactType_Id
     * @param \StructType\ContactSummary $contact
     */
    public function __construct($isPrimary = null, $opportunityContactType_Id = null, \StructType\ContactSummary $contact = null)
    {
        $this
            ->setIsPrimary($isPrimary)
            ->setOpportunityContactType_Id($opportunityContactType_Id)
            ->setContact($contact);
    }
    /**
     * Get IsPrimary value
     * @return bool
     */
    public function getIsPrimary()
    {
        return $this->IsPrimary;
    }
    /**
     * Set IsPrimary value
     * @param bool $isPrimary
     * @return \StructType\OpportunityContactRecord
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPrimary)), __LINE__);
        }
        $this->IsPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get OpportunityContactType_Id value
     * @return int
     */
    public function getOpportunityContactType_Id()
    {
        return $this->OpportunityContactType_Id;
    }
    /**
     * Set OpportunityContactType_Id value
     * @param int $opportunityContactType_Id
     * @return \StructType\OpportunityContactRecord
     */
    public function setOpportunityContactType_Id($opportunityContactType_Id = null)
    {
        // validation for constraint: int
        if (!is_null($opportunityContactType_Id) && !is_numeric($opportunityContactType_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($opportunityContactType_Id)), __LINE__);
        }
        $this->OpportunityContactType_Id = $opportunityContactType_Id;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\OpportunityContactRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OpportunityContactRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
