<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntegrationApiResponseBase StructType
 * @subpackage Structs
 */
class IntegrationApiResponseBase extends AbstractStructBase
{
    /**
     * The Successful
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Successful;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IntegrationApiError
     */
    public $Error;
    /**
     * The ValidationMessages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfValidationMessage
     */
    public $ValidationMessages;
    /**
     * Constructor method for IntegrationApiResponseBase
     * @uses IntegrationApiResponseBase::setSuccessful()
     * @uses IntegrationApiResponseBase::setError()
     * @uses IntegrationApiResponseBase::setValidationMessages()
     * @param bool $successful
     * @param \StructType\IntegrationApiError $error
     * @param \ArrayType\ArrayOfValidationMessage $validationMessages
     */
    public function __construct($successful = null, \StructType\IntegrationApiError $error = null, \ArrayType\ArrayOfValidationMessage $validationMessages = null)
    {
        $this
            ->setSuccessful($successful)
            ->setError($error)
            ->setValidationMessages($validationMessages);
    }
    /**
     * Get Successful value
     * @return bool
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\IntegrationApiResponseBase
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
    /**
     * Get Error value
     * @return \StructType\IntegrationApiError|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param \StructType\IntegrationApiError $error
     * @return \StructType\IntegrationApiResponseBase
     */
    public function setError(\StructType\IntegrationApiError $error = null)
    {
        $this->Error = $error;
        return $this;
    }
    /**
     * Get ValidationMessages value
     * @return \ArrayType\ArrayOfValidationMessage|null
     */
    public function getValidationMessages()
    {
        return $this->ValidationMessages;
    }
    /**
     * Set ValidationMessages value
     * @param \ArrayType\ArrayOfValidationMessage $validationMessages
     * @return \StructType\IntegrationApiResponseBase
     */
    public function setValidationMessages(\ArrayType\ArrayOfValidationMessage $validationMessages = null)
    {
        $this->ValidationMessages = $validationMessages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IntegrationApiResponseBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
