<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntegrationApiQueryResponse StructType
 * @subpackage Structs
 */
class IntegrationApiQueryResponse extends IntegrationApiResponseBase
{
    /**
     * The QueryRecordCount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $QueryRecordCount;
    /**
     * Constructor method for IntegrationApiQueryResponse
     * @uses IntegrationApiQueryResponse::setQueryRecordCount()
     * @param int $queryRecordCount
     */
    public function __construct($queryRecordCount = null)
    {
        $this
            ->setQueryRecordCount($queryRecordCount);
    }
    /**
     * Get QueryRecordCount value
     * @return int
     */
    public function getQueryRecordCount()
    {
        return $this->QueryRecordCount;
    }
    /**
     * Set QueryRecordCount value
     * @param int $queryRecordCount
     * @return \StructType\IntegrationApiQueryResponse
     */
    public function setQueryRecordCount($queryRecordCount = null)
    {
        // validation for constraint: int
        if (!is_null($queryRecordCount) && !is_numeric($queryRecordCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($queryRecordCount)), __LINE__);
        }
        $this->QueryRecordCount = $queryRecordCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IntegrationApiQueryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
