<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstantMessengerIdRecord StructType
 * @subpackage Structs
 */
class InstantMessengerIdRecord extends DataRecord
{
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Contact_Id;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The IsPreferredMessenger
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsPreferredMessenger;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InstantMessengerType
     */
    public $Type;
    /**
     * The ScreenName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScreenName;
    /**
     * Constructor method for InstantMessengerIdRecord
     * @uses InstantMessengerIdRecord::setContact_Id()
     * @uses InstantMessengerIdRecord::setActive()
     * @uses InstantMessengerIdRecord::setIsPreferredMessenger()
     * @uses InstantMessengerIdRecord::setType()
     * @uses InstantMessengerIdRecord::setScreenName()
     * @param int $contact_Id
     * @param bool $active
     * @param bool $isPreferredMessenger
     * @param \StructType\InstantMessengerType $type
     * @param string $screenName
     */
    public function __construct($contact_Id = null, $active = null, $isPreferredMessenger = null, \StructType\InstantMessengerType $type = null, $screenName = null)
    {
        $this
            ->setContact_Id($contact_Id)
            ->setActive($active)
            ->setIsPreferredMessenger($isPreferredMessenger)
            ->setType($type)
            ->setScreenName($screenName);
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\InstantMessengerIdRecord
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\InstantMessengerIdRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get IsPreferredMessenger value
     * @return bool
     */
    public function getIsPreferredMessenger()
    {
        return $this->IsPreferredMessenger;
    }
    /**
     * Set IsPreferredMessenger value
     * @param bool $isPreferredMessenger
     * @return \StructType\InstantMessengerIdRecord
     */
    public function setIsPreferredMessenger($isPreferredMessenger = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPreferredMessenger) && !is_bool($isPreferredMessenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPreferredMessenger)), __LINE__);
        }
        $this->IsPreferredMessenger = $isPreferredMessenger;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\InstantMessengerType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\InstantMessengerType $type
     * @return \StructType\InstantMessengerIdRecord
     */
    public function setType(\StructType\InstantMessengerType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ScreenName value
     * @return string|null
     */
    public function getScreenName()
    {
        return $this->ScreenName;
    }
    /**
     * Set ScreenName value
     * @param string $screenName
     * @return \StructType\InstantMessengerIdRecord
     */
    public function setScreenName($screenName = null)
    {
        // validation for constraint: string
        if (!is_null($screenName) && !is_string($screenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($screenName)), __LINE__);
        }
        $this->ScreenName = $screenName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InstantMessengerIdRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
