<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiativeMessageViewRecord StructType
 * @subpackage Structs
 */
class InitiativeMessageViewRecord extends DataRecord
{
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * The Initiative
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InitiativeDetail
     */
    public $Initiative;
    /**
     * Constructor method for InitiativeMessageViewRecord
     * @uses InitiativeMessageViewRecord::setContact()
     * @uses InitiativeMessageViewRecord::setInitiative()
     * @param \StructType\ContactSummary $contact
     * @param \StructType\InitiativeDetail $initiative
     */
    public function __construct(\StructType\ContactSummary $contact = null, \StructType\InitiativeDetail $initiative = null)
    {
        $this
            ->setContact($contact)
            ->setInitiative($initiative);
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\InitiativeMessageViewRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Initiative value
     * @return \StructType\InitiativeDetail|null
     */
    public function getInitiative()
    {
        return $this->Initiative;
    }
    /**
     * Set Initiative value
     * @param \StructType\InitiativeDetail $initiative
     * @return \StructType\InitiativeMessageViewRecord
     */
    public function setInitiative(\StructType\InitiativeDetail $initiative = null)
    {
        $this->Initiative = $initiative;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InitiativeMessageViewRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
