<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiativeMessageDeliveryFailureRecord StructType
 * @subpackage Structs
 */
class InitiativeMessageDeliveryFailureRecord extends DataRecord
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Reason;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * The Initiative
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InitiativeDetail
     */
    public $Initiative;
    /**
     * Constructor method for InitiativeMessageDeliveryFailureRecord
     * @uses InitiativeMessageDeliveryFailureRecord::setType()
     * @uses InitiativeMessageDeliveryFailureRecord::setReason()
     * @uses InitiativeMessageDeliveryFailureRecord::setContact()
     * @uses InitiativeMessageDeliveryFailureRecord::setInitiative()
     * @param string $type
     * @param string $reason
     * @param \StructType\ContactSummary $contact
     * @param \StructType\InitiativeDetail $initiative
     */
    public function __construct($type = null, $reason = null, \StructType\ContactSummary $contact = null, \StructType\InitiativeDetail $initiative = null)
    {
        $this
            ->setType($type)
            ->setReason($reason)
            ->setContact($contact)
            ->setInitiative($initiative);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\InitiativeMessageDeliveryFailTypes::valueIsValid()
     * @uses \EnumType\InitiativeMessageDeliveryFailTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\InitiativeMessageDeliveryFailureRecord
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InitiativeMessageDeliveryFailTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\InitiativeMessageDeliveryFailTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Reason value
     * @return string
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @uses \EnumType\InitiativeMessageDeliveryFailReasons::valueIsValid()
     * @uses \EnumType\InitiativeMessageDeliveryFailReasons::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reason
     * @return \StructType\InitiativeMessageDeliveryFailureRecord
     */
    public function setReason($reason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InitiativeMessageDeliveryFailReasons::valueIsValid($reason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reason, implode(', ', \EnumType\InitiativeMessageDeliveryFailReasons::getValidValues())), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\InitiativeMessageDeliveryFailureRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Initiative value
     * @return \StructType\InitiativeDetail|null
     */
    public function getInitiative()
    {
        return $this->Initiative;
    }
    /**
     * Set Initiative value
     * @param \StructType\InitiativeDetail $initiative
     * @return \StructType\InitiativeMessageDeliveryFailureRecord
     */
    public function setInitiative(\StructType\InitiativeDetail $initiative = null)
    {
        $this->Initiative = $initiative;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InitiativeMessageDeliveryFailureRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
