<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiativeClickThroughRecord StructType
 * @subpackage Structs
 */
class InitiativeClickThroughRecord extends DataRecord
{
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * The Initiative
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InitiativeDetail
     */
    public $Initiative;
    /**
     * The Link
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MessageLinkDetail
     */
    public $Link;
    /**
     * Constructor method for InitiativeClickThroughRecord
     * @uses InitiativeClickThroughRecord::setContact()
     * @uses InitiativeClickThroughRecord::setInitiative()
     * @uses InitiativeClickThroughRecord::setLink()
     * @param \StructType\ContactSummary $contact
     * @param \StructType\InitiativeDetail $initiative
     * @param \StructType\MessageLinkDetail $link
     */
    public function __construct(\StructType\ContactSummary $contact = null, \StructType\InitiativeDetail $initiative = null, \StructType\MessageLinkDetail $link = null)
    {
        $this
            ->setContact($contact)
            ->setInitiative($initiative)
            ->setLink($link);
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\InitiativeClickThroughRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Initiative value
     * @return \StructType\InitiativeDetail|null
     */
    public function getInitiative()
    {
        return $this->Initiative;
    }
    /**
     * Set Initiative value
     * @param \StructType\InitiativeDetail $initiative
     * @return \StructType\InitiativeClickThroughRecord
     */
    public function setInitiative(\StructType\InitiativeDetail $initiative = null)
    {
        $this->Initiative = $initiative;
        return $this;
    }
    /**
     * Get Link value
     * @return \StructType\MessageLinkDetail|null
     */
    public function getLink()
    {
        return $this->Link;
    }
    /**
     * Set Link value
     * @param \StructType\MessageLinkDetail $link
     * @return \StructType\InitiativeClickThroughRecord
     */
    public function setLink(\StructType\MessageLinkDetail $link = null)
    {
        $this->Link = $link;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InitiativeClickThroughRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
