<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPeerToPeerMicrositesQuery StructType
 * @subpackage Structs
 */
class GetPeerToPeerMicrositesQuery extends DateAdvancedPagingQuery
{
    /**
     * The Microsite_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Microsite_Id;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for GetPeerToPeerMicrositesQuery
     * @uses GetPeerToPeerMicrositesQuery::setMicrosite_Id()
     * @uses GetPeerToPeerMicrositesQuery::setActive()
     * @param int $microsite_Id
     * @param bool $active
     */
    public function __construct($microsite_Id = null, $active = null)
    {
        $this
            ->setMicrosite_Id($microsite_Id)
            ->setActive($active);
    }
    /**
     * Get Microsite_Id value
     * @return int
     */
    public function getMicrosite_Id()
    {
        return $this->Microsite_Id;
    }
    /**
     * Set Microsite_Id value
     * @param int $microsite_Id
     * @return \StructType\GetPeerToPeerMicrositesQuery
     */
    public function setMicrosite_Id($microsite_Id = null)
    {
        // validation for constraint: int
        if (!is_null($microsite_Id) && !is_numeric($microsite_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($microsite_Id)), __LINE__);
        }
        $this->Microsite_Id = $microsite_Id;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\GetPeerToPeerMicrositesQuery
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPeerToPeerMicrositesQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
