<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventsQuery StructType
 * @subpackage Structs
 */
class GetEventsQuery extends DateAdvancedPagingQuery
{
    /**
     * The Event_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Event_Id;
    /**
     * The EventType_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EventType_Id;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The StartDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDateFrom;
    /**
     * The StartDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDateTo;
    /**
     * The EndDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDateFrom;
    /**
     * The EndDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDateTo;
    /**
     * The EventName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventName;
    /**
     * Constructor method for GetEventsQuery
     * @uses GetEventsQuery::setEvent_Id()
     * @uses GetEventsQuery::setEventType_Id()
     * @uses GetEventsQuery::setActive()
     * @uses GetEventsQuery::setStartDateFrom()
     * @uses GetEventsQuery::setStartDateTo()
     * @uses GetEventsQuery::setEndDateFrom()
     * @uses GetEventsQuery::setEndDateTo()
     * @uses GetEventsQuery::setEventName()
     * @param int $event_Id
     * @param int $eventType_Id
     * @param bool $active
     * @param string $startDateFrom
     * @param string $startDateTo
     * @param string $endDateFrom
     * @param string $endDateTo
     * @param string $eventName
     */
    public function __construct($event_Id = null, $eventType_Id = null, $active = null, $startDateFrom = null, $startDateTo = null, $endDateFrom = null, $endDateTo = null, $eventName = null)
    {
        $this
            ->setEvent_Id($event_Id)
            ->setEventType_Id($eventType_Id)
            ->setActive($active)
            ->setStartDateFrom($startDateFrom)
            ->setStartDateTo($startDateTo)
            ->setEndDateFrom($endDateFrom)
            ->setEndDateTo($endDateTo)
            ->setEventName($eventName);
    }
    /**
     * Get Event_Id value
     * @return int
     */
    public function getEvent_Id()
    {
        return $this->Event_Id;
    }
    /**
     * Set Event_Id value
     * @param int $event_Id
     * @return \StructType\GetEventsQuery
     */
    public function setEvent_Id($event_Id = null)
    {
        // validation for constraint: int
        if (!is_null($event_Id) && !is_numeric($event_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($event_Id)), __LINE__);
        }
        $this->Event_Id = $event_Id;
        return $this;
    }
    /**
     * Get EventType_Id value
     * @return int
     */
    public function getEventType_Id()
    {
        return $this->EventType_Id;
    }
    /**
     * Set EventType_Id value
     * @param int $eventType_Id
     * @return \StructType\GetEventsQuery
     */
    public function setEventType_Id($eventType_Id = null)
    {
        // validation for constraint: int
        if (!is_null($eventType_Id) && !is_numeric($eventType_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eventType_Id)), __LINE__);
        }
        $this->EventType_Id = $eventType_Id;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\GetEventsQuery
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get StartDateFrom value
     * @return string
     */
    public function getStartDateFrom()
    {
        return $this->StartDateFrom;
    }
    /**
     * Set StartDateFrom value
     * @param string $startDateFrom
     * @return \StructType\GetEventsQuery
     */
    public function setStartDateFrom($startDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($startDateFrom) && !is_string($startDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDateFrom)), __LINE__);
        }
        $this->StartDateFrom = $startDateFrom;
        return $this;
    }
    /**
     * Get StartDateTo value
     * @return string
     */
    public function getStartDateTo()
    {
        return $this->StartDateTo;
    }
    /**
     * Set StartDateTo value
     * @param string $startDateTo
     * @return \StructType\GetEventsQuery
     */
    public function setStartDateTo($startDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTo) && !is_string($startDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDateTo)), __LINE__);
        }
        $this->StartDateTo = $startDateTo;
        return $this;
    }
    /**
     * Get EndDateFrom value
     * @return string
     */
    public function getEndDateFrom()
    {
        return $this->EndDateFrom;
    }
    /**
     * Set EndDateFrom value
     * @param string $endDateFrom
     * @return \StructType\GetEventsQuery
     */
    public function setEndDateFrom($endDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($endDateFrom) && !is_string($endDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDateFrom)), __LINE__);
        }
        $this->EndDateFrom = $endDateFrom;
        return $this;
    }
    /**
     * Get EndDateTo value
     * @return string
     */
    public function getEndDateTo()
    {
        return $this->EndDateTo;
    }
    /**
     * Set EndDateTo value
     * @param string $endDateTo
     * @return \StructType\GetEventsQuery
     */
    public function setEndDateTo($endDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTo) && !is_string($endDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDateTo)), __LINE__);
        }
        $this->EndDateTo = $endDateTo;
        return $this;
    }
    /**
     * Get EventName value
     * @return string|null
     */
    public function getEventName()
    {
        return $this->EventName;
    }
    /**
     * Set EventName value
     * @param string $eventName
     * @return \StructType\GetEventsQuery
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventName)), __LINE__);
        }
        $this->EventName = $eventName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEventsQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
