<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventRegistrationsQuery StructType
 * @subpackage Structs
 */
class GetEventRegistrationsQuery extends DateAdvancedPagingQuery
{
    /**
     * The Registration_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Registration_Id;
    /**
     * The Event_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Event_Id;
    /**
     * Constructor method for GetEventRegistrationsQuery
     * @uses GetEventRegistrationsQuery::setRegistration_Id()
     * @uses GetEventRegistrationsQuery::setEvent_Id()
     * @param int $registration_Id
     * @param int $event_Id
     */
    public function __construct($registration_Id = null, $event_Id = null)
    {
        $this
            ->setRegistration_Id($registration_Id)
            ->setEvent_Id($event_Id);
    }
    /**
     * Get Registration_Id value
     * @return int
     */
    public function getRegistration_Id()
    {
        return $this->Registration_Id;
    }
    /**
     * Set Registration_Id value
     * @param int $registration_Id
     * @return \StructType\GetEventRegistrationsQuery
     */
    public function setRegistration_Id($registration_Id = null)
    {
        // validation for constraint: int
        if (!is_null($registration_Id) && !is_numeric($registration_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($registration_Id)), __LINE__);
        }
        $this->Registration_Id = $registration_Id;
        return $this;
    }
    /**
     * Get Event_Id value
     * @return int
     */
    public function getEvent_Id()
    {
        return $this->Event_Id;
    }
    /**
     * Set Event_Id value
     * @param int $event_Id
     * @return \StructType\GetEventRegistrationsQuery
     */
    public function setEvent_Id($event_Id = null)
    {
        // validation for constraint: int
        if (!is_null($event_Id) && !is_numeric($event_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($event_Id)), __LINE__);
        }
        $this->Event_Id = $event_Id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEventRegistrationsQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
