<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAddressesQuery StructType
 * @subpackage Structs
 */
class GetAddressesQuery extends DateAdvancedPagingQuery
{
    /**
     * The Address_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Address_Id;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Contact_Id;
    /**
     * The StateProvince_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $StateProvince_Id;
    /**
     * The Country_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Country_Id;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * Constructor method for GetAddressesQuery
     * @uses GetAddressesQuery::setAddress_Id()
     * @uses GetAddressesQuery::setContact_Id()
     * @uses GetAddressesQuery::setStateProvince_Id()
     * @uses GetAddressesQuery::setCountry_Id()
     * @uses GetAddressesQuery::setCity()
     * @uses GetAddressesQuery::setPostalCode()
     * @param int $address_Id
     * @param int $contact_Id
     * @param int $stateProvince_Id
     * @param int $country_Id
     * @param string $city
     * @param string $postalCode
     */
    public function __construct($address_Id = null, $contact_Id = null, $stateProvince_Id = null, $country_Id = null, $city = null, $postalCode = null)
    {
        $this
            ->setAddress_Id($address_Id)
            ->setContact_Id($contact_Id)
            ->setStateProvince_Id($stateProvince_Id)
            ->setCountry_Id($country_Id)
            ->setCity($city)
            ->setPostalCode($postalCode);
    }
    /**
     * Get Address_Id value
     * @return int
     */
    public function getAddress_Id()
    {
        return $this->Address_Id;
    }
    /**
     * Set Address_Id value
     * @param int $address_Id
     * @return \StructType\GetAddressesQuery
     */
    public function setAddress_Id($address_Id = null)
    {
        // validation for constraint: int
        if (!is_null($address_Id) && !is_numeric($address_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($address_Id)), __LINE__);
        }
        $this->Address_Id = $address_Id;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\GetAddressesQuery
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get StateProvince_Id value
     * @return int
     */
    public function getStateProvince_Id()
    {
        return $this->StateProvince_Id;
    }
    /**
     * Set StateProvince_Id value
     * @param int $stateProvince_Id
     * @return \StructType\GetAddressesQuery
     */
    public function setStateProvince_Id($stateProvince_Id = null)
    {
        // validation for constraint: int
        if (!is_null($stateProvince_Id) && !is_numeric($stateProvince_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stateProvince_Id)), __LINE__);
        }
        $this->StateProvince_Id = $stateProvince_Id;
        return $this;
    }
    /**
     * Get Country_Id value
     * @return int
     */
    public function getCountry_Id()
    {
        return $this->Country_Id;
    }
    /**
     * Set Country_Id value
     * @param int $country_Id
     * @return \StructType\GetAddressesQuery
     */
    public function setCountry_Id($country_Id = null)
    {
        // validation for constraint: int
        if (!is_null($country_Id) && !is_numeric($country_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($country_Id)), __LINE__);
        }
        $this->Country_Id = $country_Id;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\GetAddressesQuery
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\GetAddressesQuery
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAddressesQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
