<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindOrCreateAudienceSegmentParameters StructType
 * @subpackage Structs
 */
class FindOrCreateAudienceSegmentParameters extends FindOrCreateRecordParameters
{
    /**
     * The Initiative_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Initiative_Id;
    /**
     * The PhoneNumber_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PhoneNumber_Id;
    /**
     * The AudienceSegmentCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AudienceSegmentCode;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * Constructor method for FindOrCreateAudienceSegmentParameters
     * @uses FindOrCreateAudienceSegmentParameters::setInitiative_Id()
     * @uses FindOrCreateAudienceSegmentParameters::setPhoneNumber_Id()
     * @uses FindOrCreateAudienceSegmentParameters::setAudienceSegmentCode()
     * @uses FindOrCreateAudienceSegmentParameters::setPhoneNumber()
     * @param int $initiative_Id
     * @param int $phoneNumber_Id
     * @param string $audienceSegmentCode
     * @param string $phoneNumber
     */
    public function __construct($initiative_Id = null, $phoneNumber_Id = null, $audienceSegmentCode = null, $phoneNumber = null)
    {
        $this
            ->setInitiative_Id($initiative_Id)
            ->setPhoneNumber_Id($phoneNumber_Id)
            ->setAudienceSegmentCode($audienceSegmentCode)
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get Initiative_Id value
     * @return int
     */
    public function getInitiative_Id()
    {
        return $this->Initiative_Id;
    }
    /**
     * Set Initiative_Id value
     * @param int $initiative_Id
     * @return \StructType\FindOrCreateAudienceSegmentParameters
     */
    public function setInitiative_Id($initiative_Id = null)
    {
        // validation for constraint: int
        if (!is_null($initiative_Id) && !is_numeric($initiative_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($initiative_Id)), __LINE__);
        }
        $this->Initiative_Id = $initiative_Id;
        return $this;
    }
    /**
     * Get PhoneNumber_Id value
     * @return int
     */
    public function getPhoneNumber_Id()
    {
        return $this->PhoneNumber_Id;
    }
    /**
     * Set PhoneNumber_Id value
     * @param int $phoneNumber_Id
     * @return \StructType\FindOrCreateAudienceSegmentParameters
     */
    public function setPhoneNumber_Id($phoneNumber_Id = null)
    {
        // validation for constraint: int
        if (!is_null($phoneNumber_Id) && !is_numeric($phoneNumber_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($phoneNumber_Id)), __LINE__);
        }
        $this->PhoneNumber_Id = $phoneNumber_Id;
        return $this;
    }
    /**
     * Get AudienceSegmentCode value
     * @return string|null
     */
    public function getAudienceSegmentCode()
    {
        return $this->AudienceSegmentCode;
    }
    /**
     * Set AudienceSegmentCode value
     * @param string $audienceSegmentCode
     * @return \StructType\FindOrCreateAudienceSegmentParameters
     */
    public function setAudienceSegmentCode($audienceSegmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($audienceSegmentCode) && !is_string($audienceSegmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($audienceSegmentCode)), __LINE__);
        }
        $this->AudienceSegmentCode = $audienceSegmentCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\FindOrCreateAudienceSegmentParameters
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FindOrCreateAudienceSegmentParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
