<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ECheckParameters StructType
 * @subpackage Structs
 */
class ECheckParameters extends SubParameters
{
    /**
     * The ECheckType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ECheckType;
    /**
     * The CheckNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckNumber;
    /**
     * The BankAccountInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BankAccountParameters
     */
    public $BankAccountInfo;
    /**
     * Constructor method for ECheckParameters
     * @uses ECheckParameters::setECheckType()
     * @uses ECheckParameters::setCheckNumber()
     * @uses ECheckParameters::setBankAccountInfo()
     * @param string $eCheckType
     * @param string $checkNumber
     * @param \StructType\BankAccountParameters $bankAccountInfo
     */
    public function __construct($eCheckType = null, $checkNumber = null, \StructType\BankAccountParameters $bankAccountInfo = null)
    {
        $this
            ->setECheckType($eCheckType)
            ->setCheckNumber($checkNumber)
            ->setBankAccountInfo($bankAccountInfo);
    }
    /**
     * Get ECheckType value
     * @return string
     */
    public function getECheckType()
    {
        return $this->ECheckType;
    }
    /**
     * Set ECheckType value
     * @uses \EnumType\ECheckTypes::valueIsValid()
     * @uses \EnumType\ECheckTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eCheckType
     * @return \StructType\ECheckParameters
     */
    public function setECheckType($eCheckType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ECheckTypes::valueIsValid($eCheckType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eCheckType, implode(', ', \EnumType\ECheckTypes::getValidValues())), __LINE__);
        }
        $this->ECheckType = $eCheckType;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param string $checkNumber
     * @return \StructType\ECheckParameters
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get BankAccountInfo value
     * @return \StructType\BankAccountParameters|null
     */
    public function getBankAccountInfo()
    {
        return $this->BankAccountInfo;
    }
    /**
     * Set BankAccountInfo value
     * @param \StructType\BankAccountParameters $bankAccountInfo
     * @return \StructType\ECheckParameters
     */
    public function setBankAccountInfo(\StructType\BankAccountParameters $bankAccountInfo = null)
    {
        $this->BankAccountInfo = $bankAccountInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ECheckParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
