<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRelationshipParameters StructType
 * @subpackage Structs
 */
class CreateRelationshipParameters extends CreateRecordParameters
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The PrimaryContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $PrimaryContact;
    /**
     * The PrimaryContactRelationshipType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateRelationshipTypeParameters
     */
    public $PrimaryContactRelationshipType;
    /**
     * The RelatedContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $RelatedContact;
    /**
     * The RelatedContactRelationshipType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateRelationshipTypeParameters
     */
    public $RelatedContactRelationshipType;
    /**
     * Constructor method for CreateRelationshipParameters
     * @uses CreateRelationshipParameters::setStartDate()
     * @uses CreateRelationshipParameters::setEndDate()
     * @uses CreateRelationshipParameters::setPrimaryContact()
     * @uses CreateRelationshipParameters::setPrimaryContactRelationshipType()
     * @uses CreateRelationshipParameters::setRelatedContact()
     * @uses CreateRelationshipParameters::setRelatedContactRelationshipType()
     * @param string $startDate
     * @param string $endDate
     * @param \StructType\FindOrCreateContactParameters $primaryContact
     * @param \StructType\FindOrCreateRelationshipTypeParameters $primaryContactRelationshipType
     * @param \StructType\FindOrCreateContactParameters $relatedContact
     * @param \StructType\FindOrCreateRelationshipTypeParameters $relatedContactRelationshipType
     */
    public function __construct($startDate = null, $endDate = null, \StructType\FindOrCreateContactParameters $primaryContact = null, \StructType\FindOrCreateRelationshipTypeParameters $primaryContactRelationshipType = null, \StructType\FindOrCreateContactParameters $relatedContact = null, \StructType\FindOrCreateRelationshipTypeParameters $relatedContactRelationshipType = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setPrimaryContact($primaryContact)
            ->setPrimaryContactRelationshipType($primaryContactRelationshipType)
            ->setRelatedContact($relatedContact)
            ->setRelatedContactRelationshipType($relatedContactRelationshipType);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\CreateRelationshipParameters
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\CreateRelationshipParameters
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get PrimaryContact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getPrimaryContact()
    {
        return $this->PrimaryContact;
    }
    /**
     * Set PrimaryContact value
     * @param \StructType\FindOrCreateContactParameters $primaryContact
     * @return \StructType\CreateRelationshipParameters
     */
    public function setPrimaryContact(\StructType\FindOrCreateContactParameters $primaryContact = null)
    {
        $this->PrimaryContact = $primaryContact;
        return $this;
    }
    /**
     * Get PrimaryContactRelationshipType value
     * @return \StructType\FindOrCreateRelationshipTypeParameters|null
     */
    public function getPrimaryContactRelationshipType()
    {
        return $this->PrimaryContactRelationshipType;
    }
    /**
     * Set PrimaryContactRelationshipType value
     * @param \StructType\FindOrCreateRelationshipTypeParameters $primaryContactRelationshipType
     * @return \StructType\CreateRelationshipParameters
     */
    public function setPrimaryContactRelationshipType(\StructType\FindOrCreateRelationshipTypeParameters $primaryContactRelationshipType = null)
    {
        $this->PrimaryContactRelationshipType = $primaryContactRelationshipType;
        return $this;
    }
    /**
     * Get RelatedContact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getRelatedContact()
    {
        return $this->RelatedContact;
    }
    /**
     * Set RelatedContact value
     * @param \StructType\FindOrCreateContactParameters $relatedContact
     * @return \StructType\CreateRelationshipParameters
     */
    public function setRelatedContact(\StructType\FindOrCreateContactParameters $relatedContact = null)
    {
        $this->RelatedContact = $relatedContact;
        return $this;
    }
    /**
     * Get RelatedContactRelationshipType value
     * @return \StructType\FindOrCreateRelationshipTypeParameters|null
     */
    public function getRelatedContactRelationshipType()
    {
        return $this->RelatedContactRelationshipType;
    }
    /**
     * Set RelatedContactRelationshipType value
     * @param \StructType\FindOrCreateRelationshipTypeParameters $relatedContactRelationshipType
     * @return \StructType\CreateRelationshipParameters
     */
    public function setRelatedContactRelationshipType(\StructType\FindOrCreateRelationshipTypeParameters $relatedContactRelationshipType = null)
    {
        $this->RelatedContactRelationshipType = $relatedContactRelationshipType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateRelationshipParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
