<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCashPaymentParameters StructType
 * @subpackage Structs
 */
class CreateCashPaymentParameters extends CreateRecordParameters
{
    /**
     * The TaxDeductibleAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxDeductibleAmount;
    /**
     * The PaymentConfirmed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PaymentConfirmed;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $Contact;
    /**
     * The PaymentBillingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentBillingContactParameters
     */
    public $PaymentBillingInfo;
    /**
     * The PrivacyPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentPrivacyPreferenceParameters
     */
    public $PrivacyPreferences;
    /**
     * The Billing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BillingEngineParameters
     */
    public $Billing;
    /**
     * The Attribution
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributionParameters
     */
    public $Attribution;
    /**
     * The UpdateContactActions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactUpdateActionParameters
     */
    public $UpdateContactActions;
    /**
     * Constructor method for CreateCashPaymentParameters
     * @uses CreateCashPaymentParameters::setTaxDeductibleAmount()
     * @uses CreateCashPaymentParameters::setPaymentConfirmed()
     * @uses CreateCashPaymentParameters::setAmount()
     * @uses CreateCashPaymentParameters::setContact()
     * @uses CreateCashPaymentParameters::setPaymentBillingInfo()
     * @uses CreateCashPaymentParameters::setPrivacyPreferences()
     * @uses CreateCashPaymentParameters::setBilling()
     * @uses CreateCashPaymentParameters::setAttribution()
     * @uses CreateCashPaymentParameters::setUpdateContactActions()
     * @param float $taxDeductibleAmount
     * @param bool $paymentConfirmed
     * @param float $amount
     * @param \StructType\FindOrCreateContactParameters $contact
     * @param \StructType\PaymentBillingContactParameters $paymentBillingInfo
     * @param \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences
     * @param \StructType\BillingEngineParameters $billing
     * @param \StructType\AttributionParameters $attribution
     * @param \StructType\ContactUpdateActionParameters $updateContactActions
     */
    public function __construct($taxDeductibleAmount = null, $paymentConfirmed = null, $amount = null, \StructType\FindOrCreateContactParameters $contact = null, \StructType\PaymentBillingContactParameters $paymentBillingInfo = null, \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences = null, \StructType\BillingEngineParameters $billing = null, \StructType\AttributionParameters $attribution = null, \StructType\ContactUpdateActionParameters $updateContactActions = null)
    {
        $this
            ->setTaxDeductibleAmount($taxDeductibleAmount)
            ->setPaymentConfirmed($paymentConfirmed)
            ->setAmount($amount)
            ->setContact($contact)
            ->setPaymentBillingInfo($paymentBillingInfo)
            ->setPrivacyPreferences($privacyPreferences)
            ->setBilling($billing)
            ->setAttribution($attribution)
            ->setUpdateContactActions($updateContactActions);
    }
    /**
     * Get TaxDeductibleAmount value
     * @return float
     */
    public function getTaxDeductibleAmount()
    {
        return $this->TaxDeductibleAmount;
    }
    /**
     * Set TaxDeductibleAmount value
     * @param float $taxDeductibleAmount
     * @return \StructType\CreateCashPaymentParameters
     */
    public function setTaxDeductibleAmount($taxDeductibleAmount = null)
    {
        $this->TaxDeductibleAmount = $taxDeductibleAmount;
        return $this;
    }
    /**
     * Get PaymentConfirmed value
     * @return bool
     */
    public function getPaymentConfirmed()
    {
        return $this->PaymentConfirmed;
    }
    /**
     * Set PaymentConfirmed value
     * @param bool $paymentConfirmed
     * @return \StructType\CreateCashPaymentParameters
     */
    public function setPaymentConfirmed($paymentConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentConfirmed) && !is_bool($paymentConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($paymentConfirmed)), __LINE__);
        }
        $this->PaymentConfirmed = $paymentConfirmed;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CreateCashPaymentParameters
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\FindOrCreateContactParameters $contact
     * @return \StructType\CreateCashPaymentParameters
     */
    public function setContact(\StructType\FindOrCreateContactParameters $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get PaymentBillingInfo value
     * @return \StructType\PaymentBillingContactParameters|null
     */
    public function getPaymentBillingInfo()
    {
        return $this->PaymentBillingInfo;
    }
    /**
     * Set PaymentBillingInfo value
     * @param \StructType\PaymentBillingContactParameters $paymentBillingInfo
     * @return \StructType\CreateCashPaymentParameters
     */
    public function setPaymentBillingInfo(\StructType\PaymentBillingContactParameters $paymentBillingInfo = null)
    {
        $this->PaymentBillingInfo = $paymentBillingInfo;
        return $this;
    }
    /**
     * Get PrivacyPreferences value
     * @return \StructType\PaymentPrivacyPreferenceParameters|null
     */
    public function getPrivacyPreferences()
    {
        return $this->PrivacyPreferences;
    }
    /**
     * Set PrivacyPreferences value
     * @param \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences
     * @return \StructType\CreateCashPaymentParameters
     */
    public function setPrivacyPreferences(\StructType\PaymentPrivacyPreferenceParameters $privacyPreferences = null)
    {
        $this->PrivacyPreferences = $privacyPreferences;
        return $this;
    }
    /**
     * Get Billing value
     * @return \StructType\BillingEngineParameters|null
     */
    public function getBilling()
    {
        return $this->Billing;
    }
    /**
     * Set Billing value
     * @param \StructType\BillingEngineParameters $billing
     * @return \StructType\CreateCashPaymentParameters
     */
    public function setBilling(\StructType\BillingEngineParameters $billing = null)
    {
        $this->Billing = $billing;
        return $this;
    }
    /**
     * Get Attribution value
     * @return \StructType\AttributionParameters|null
     */
    public function getAttribution()
    {
        return $this->Attribution;
    }
    /**
     * Set Attribution value
     * @param \StructType\AttributionParameters $attribution
     * @return \StructType\CreateCashPaymentParameters
     */
    public function setAttribution(\StructType\AttributionParameters $attribution = null)
    {
        $this->Attribution = $attribution;
        return $this;
    }
    /**
     * Get UpdateContactActions value
     * @return \StructType\ContactUpdateActionParameters|null
     */
    public function getUpdateContactActions()
    {
        return $this->UpdateContactActions;
    }
    /**
     * Set UpdateContactActions value
     * @param \StructType\ContactUpdateActionParameters $updateContactActions
     * @return \StructType\CreateCashPaymentParameters
     */
    public function setUpdateContactActions(\StructType\ContactUpdateActionParameters $updateContactActions = null)
    {
        $this->UpdateContactActions = $updateContactActions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCashPaymentParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
