<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountryDetail StructType
 * @subpackage Structs
 */
class CountryDetail extends CodedMetaDataRecord
{
    /**
     * The Continent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Continent
     */
    public $Continent;
    /**
     * The Alias
     * @var string
     */
    public $Alias;
    /**
     * Constructor method for CountryDetail
     * @uses CountryDetail::setContinent()
     * @uses CountryDetail::setAlias()
     * @param \StructType\Continent $continent
     * @param string $alias
     */
    public function __construct(\StructType\Continent $continent = null, $alias = null)
    {
        $this
            ->setContinent($continent)
            ->setAlias($alias);
    }
    /**
     * Get Continent value
     * @return \StructType\Continent|null
     */
    public function getContinent()
    {
        return $this->Continent;
    }
    /**
     * Set Continent value
     * @param \StructType\Continent $continent
     * @return \StructType\CountryDetail
     */
    public function setContinent(\StructType\Continent $continent = null)
    {
        $this->Continent = $continent;
        return $this;
    }
    /**
     * Get Alias value
     * @return string|null
     */
    public function getAlias()
    {
        return $this->Alias;
    }
    /**
     * Set Alias value
     * @param string $alias
     * @return \StructType\CountryDetail
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alias)), __LINE__);
        }
        $this->Alias = $alias;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CountryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
