<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeContactPaymentProfileParameters StructType
 * @subpackage Structs
 */
class ChargeContactPaymentProfileParameters extends CreateRecordParameters
{
    /**
     * The TaxDeductibleAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxDeductibleAmount;
    /**
     * The PaymentProfile_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PaymentProfile_Id;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The Attribution
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributionParameters
     */
    public $Attribution;
    /**
     * Constructor method for ChargeContactPaymentProfileParameters
     * @uses ChargeContactPaymentProfileParameters::setTaxDeductibleAmount()
     * @uses ChargeContactPaymentProfileParameters::setPaymentProfile_Id()
     * @uses ChargeContactPaymentProfileParameters::setAmount()
     * @uses ChargeContactPaymentProfileParameters::setAttribution()
     * @param float $taxDeductibleAmount
     * @param int $paymentProfile_Id
     * @param float $amount
     * @param \StructType\AttributionParameters $attribution
     */
    public function __construct($taxDeductibleAmount = null, $paymentProfile_Id = null, $amount = null, \StructType\AttributionParameters $attribution = null)
    {
        $this
            ->setTaxDeductibleAmount($taxDeductibleAmount)
            ->setPaymentProfile_Id($paymentProfile_Id)
            ->setAmount($amount)
            ->setAttribution($attribution);
    }
    /**
     * Get TaxDeductibleAmount value
     * @return float
     */
    public function getTaxDeductibleAmount()
    {
        return $this->TaxDeductibleAmount;
    }
    /**
     * Set TaxDeductibleAmount value
     * @param float $taxDeductibleAmount
     * @return \StructType\ChargeContactPaymentProfileParameters
     */
    public function setTaxDeductibleAmount($taxDeductibleAmount = null)
    {
        $this->TaxDeductibleAmount = $taxDeductibleAmount;
        return $this;
    }
    /**
     * Get PaymentProfile_Id value
     * @return int
     */
    public function getPaymentProfile_Id()
    {
        return $this->PaymentProfile_Id;
    }
    /**
     * Set PaymentProfile_Id value
     * @param int $paymentProfile_Id
     * @return \StructType\ChargeContactPaymentProfileParameters
     */
    public function setPaymentProfile_Id($paymentProfile_Id = null)
    {
        // validation for constraint: int
        if (!is_null($paymentProfile_Id) && !is_numeric($paymentProfile_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentProfile_Id)), __LINE__);
        }
        $this->PaymentProfile_Id = $paymentProfile_Id;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ChargeContactPaymentProfileParameters
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Attribution value
     * @return \StructType\AttributionParameters|null
     */
    public function getAttribution()
    {
        return $this->Attribution;
    }
    /**
     * Set Attribution value
     * @param \StructType\AttributionParameters $attribution
     * @return \StructType\ChargeContactPaymentProfileParameters
     */
    public function setAttribution(\StructType\AttributionParameters $attribution = null)
    {
        $this->Attribution = $attribution;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargeContactPaymentProfileParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
