<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeContactOptInListParameters StructType
 * @subpackage Structs
 */
class ChangeContactOptInListParameters extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Action;
    /**
     * The OptInList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateOptInListParameters
     */
    public $OptInList;
    /**
     * Constructor method for ChangeContactOptInListParameters
     * @uses ChangeContactOptInListParameters::setAction()
     * @uses ChangeContactOptInListParameters::setOptInList()
     * @param string $action
     * @param \StructType\FindOrCreateOptInListParameters $optInList
     */
    public function __construct($action = null, \StructType\FindOrCreateOptInListParameters $optInList = null)
    {
        $this
            ->setAction($action)
            ->setOptInList($optInList);
    }
    /**
     * Get Action value
     * @return string
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\OptInListActions::valueIsValid()
     * @uses \EnumType\OptInListActions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\ChangeContactOptInListParameters
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OptInListActions::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\OptInListActions::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get OptInList value
     * @return \StructType\FindOrCreateOptInListParameters|null
     */
    public function getOptInList()
    {
        return $this->OptInList;
    }
    /**
     * Set OptInList value
     * @param \StructType\FindOrCreateOptInListParameters $optInList
     * @return \StructType\ChangeContactOptInListParameters
     */
    public function setOptInList(\StructType\FindOrCreateOptInListParameters $optInList = null)
    {
        $this->OptInList = $optInList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeContactOptInListParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
