<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingEngineParameters StructType
 * @subpackage Structs
 */
class BillingEngineParameters extends SubParameters
{
    /**
     * The Sustainer_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sustainer_Id;
    /**
     * The Pledge_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Pledge_Id;
    /**
     * The Membership_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Membership_Id;
    /**
     * The Invoice_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Invoice_Id;
    /**
     * Constructor method for BillingEngineParameters
     * @uses BillingEngineParameters::setSustainer_Id()
     * @uses BillingEngineParameters::setPledge_Id()
     * @uses BillingEngineParameters::setMembership_Id()
     * @uses BillingEngineParameters::setInvoice_Id()
     * @param int $sustainer_Id
     * @param int $pledge_Id
     * @param int $membership_Id
     * @param int $invoice_Id
     */
    public function __construct($sustainer_Id = null, $pledge_Id = null, $membership_Id = null, $invoice_Id = null)
    {
        $this
            ->setSustainer_Id($sustainer_Id)
            ->setPledge_Id($pledge_Id)
            ->setMembership_Id($membership_Id)
            ->setInvoice_Id($invoice_Id);
    }
    /**
     * Get Sustainer_Id value
     * @return int
     */
    public function getSustainer_Id()
    {
        return $this->Sustainer_Id;
    }
    /**
     * Set Sustainer_Id value
     * @param int $sustainer_Id
     * @return \StructType\BillingEngineParameters
     */
    public function setSustainer_Id($sustainer_Id = null)
    {
        // validation for constraint: int
        if (!is_null($sustainer_Id) && !is_numeric($sustainer_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sustainer_Id)), __LINE__);
        }
        $this->Sustainer_Id = $sustainer_Id;
        return $this;
    }
    /**
     * Get Pledge_Id value
     * @return int
     */
    public function getPledge_Id()
    {
        return $this->Pledge_Id;
    }
    /**
     * Set Pledge_Id value
     * @param int $pledge_Id
     * @return \StructType\BillingEngineParameters
     */
    public function setPledge_Id($pledge_Id = null)
    {
        // validation for constraint: int
        if (!is_null($pledge_Id) && !is_numeric($pledge_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pledge_Id)), __LINE__);
        }
        $this->Pledge_Id = $pledge_Id;
        return $this;
    }
    /**
     * Get Membership_Id value
     * @return int
     */
    public function getMembership_Id()
    {
        return $this->Membership_Id;
    }
    /**
     * Set Membership_Id value
     * @param int $membership_Id
     * @return \StructType\BillingEngineParameters
     */
    public function setMembership_Id($membership_Id = null)
    {
        // validation for constraint: int
        if (!is_null($membership_Id) && !is_numeric($membership_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($membership_Id)), __LINE__);
        }
        $this->Membership_Id = $membership_Id;
        return $this;
    }
    /**
     * Get Invoice_Id value
     * @return int
     */
    public function getInvoice_Id()
    {
        return $this->Invoice_Id;
    }
    /**
     * Set Invoice_Id value
     * @param int $invoice_Id
     * @return \StructType\BillingEngineParameters
     */
    public function setInvoice_Id($invoice_Id = null)
    {
        // validation for constraint: int
        if (!is_null($invoice_Id) && !is_numeric($invoice_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoice_Id)), __LINE__);
        }
        $this->Invoice_Id = $invoice_Id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillingEngineParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
