<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAccountParameters StructType
 * @subpackage Structs
 */
class BankAccountParameters extends SubParameters
{
    /**
     * The BankAccountType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $BankAccountType;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The BankCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankCity;
    /**
     * The BankStateProvince
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankStateProvince;
    /**
     * The RoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoutingNumber;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The NameOnAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameOnAccount;
    /**
     * Constructor method for BankAccountParameters
     * @uses BankAccountParameters::setBankAccountType()
     * @uses BankAccountParameters::setBankName()
     * @uses BankAccountParameters::setBankCity()
     * @uses BankAccountParameters::setBankStateProvince()
     * @uses BankAccountParameters::setRoutingNumber()
     * @uses BankAccountParameters::setAccountNumber()
     * @uses BankAccountParameters::setNameOnAccount()
     * @param string $bankAccountType
     * @param string $bankName
     * @param string $bankCity
     * @param string $bankStateProvince
     * @param string $routingNumber
     * @param string $accountNumber
     * @param string $nameOnAccount
     */
    public function __construct($bankAccountType = null, $bankName = null, $bankCity = null, $bankStateProvince = null, $routingNumber = null, $accountNumber = null, $nameOnAccount = null)
    {
        $this
            ->setBankAccountType($bankAccountType)
            ->setBankName($bankName)
            ->setBankCity($bankCity)
            ->setBankStateProvince($bankStateProvince)
            ->setRoutingNumber($routingNumber)
            ->setAccountNumber($accountNumber)
            ->setNameOnAccount($nameOnAccount);
    }
    /**
     * Get BankAccountType value
     * @return string
     */
    public function getBankAccountType()
    {
        return $this->BankAccountType;
    }
    /**
     * Set BankAccountType value
     * @uses \EnumType\BankAccountTypes::valueIsValid()
     * @uses \EnumType\BankAccountTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bankAccountType
     * @return \StructType\BankAccountParameters
     */
    public function setBankAccountType($bankAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BankAccountTypes::valueIsValid($bankAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bankAccountType, implode(', ', \EnumType\BankAccountTypes::getValidValues())), __LINE__);
        }
        $this->BankAccountType = $bankAccountType;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\BankAccountParameters
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BankCity value
     * @return string|null
     */
    public function getBankCity()
    {
        return $this->BankCity;
    }
    /**
     * Set BankCity value
     * @param string $bankCity
     * @return \StructType\BankAccountParameters
     */
    public function setBankCity($bankCity = null)
    {
        // validation for constraint: string
        if (!is_null($bankCity) && !is_string($bankCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCity)), __LINE__);
        }
        $this->BankCity = $bankCity;
        return $this;
    }
    /**
     * Get BankStateProvince value
     * @return string|null
     */
    public function getBankStateProvince()
    {
        return $this->BankStateProvince;
    }
    /**
     * Set BankStateProvince value
     * @param string $bankStateProvince
     * @return \StructType\BankAccountParameters
     */
    public function setBankStateProvince($bankStateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($bankStateProvince) && !is_string($bankStateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankStateProvince)), __LINE__);
        }
        $this->BankStateProvince = $bankStateProvince;
        return $this;
    }
    /**
     * Get RoutingNumber value
     * @return string|null
     */
    public function getRoutingNumber()
    {
        return $this->RoutingNumber;
    }
    /**
     * Set RoutingNumber value
     * @param string $routingNumber
     * @return \StructType\BankAccountParameters
     */
    public function setRoutingNumber($routingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($routingNumber) && !is_string($routingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routingNumber)), __LINE__);
        }
        $this->RoutingNumber = $routingNumber;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\BankAccountParameters
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get NameOnAccount value
     * @return string|null
     */
    public function getNameOnAccount()
    {
        return $this->NameOnAccount;
    }
    /**
     * Set NameOnAccount value
     * @param string $nameOnAccount
     * @return \StructType\BankAccountParameters
     */
    public function setNameOnAccount($nameOnAccount = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnAccount) && !is_string($nameOnAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOnAccount)), __LINE__);
        }
        $this->NameOnAccount = $nameOnAccount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankAccountParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
