<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressRecord StructType
 * @subpackage Structs
 */
class AddressRecord extends DataRecord
{
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Contact_Id;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The ReceiveMail
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ReceiveMail;
    /**
     * The AddressType_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $AddressType_Id;
    /**
     * The AddressClass_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $AddressClass_Id;
    /**
     * The IsPreferredMailing
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsPreferredMailing;
    /**
     * The IsPreferredShipping
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsPreferredShipping;
    /**
     * The SeasonalMonthFrom
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $SeasonalMonthFrom;
    /**
     * The SeasonalDayFrom
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $SeasonalDayFrom;
    /**
     * The SeasonalMonthTo
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $SeasonalMonthTo;
    /**
     * The SeasonalDayTo
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $SeasonalDayTo;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Longitude;
    /**
     * The Street1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street1;
    /**
     * The Street2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street2;
    /**
     * The Street3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street3;
    /**
     * The Street4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street4;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The StateProvince
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StateProvince
     */
    public $StateProvince;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $Country;
    /**
     * Constructor method for AddressRecord
     * @uses AddressRecord::setContact_Id()
     * @uses AddressRecord::setActive()
     * @uses AddressRecord::setReceiveMail()
     * @uses AddressRecord::setAddressType_Id()
     * @uses AddressRecord::setAddressClass_Id()
     * @uses AddressRecord::setIsPreferredMailing()
     * @uses AddressRecord::setIsPreferredShipping()
     * @uses AddressRecord::setSeasonalMonthFrom()
     * @uses AddressRecord::setSeasonalDayFrom()
     * @uses AddressRecord::setSeasonalMonthTo()
     * @uses AddressRecord::setSeasonalDayTo()
     * @uses AddressRecord::setLatitude()
     * @uses AddressRecord::setLongitude()
     * @uses AddressRecord::setStreet1()
     * @uses AddressRecord::setStreet2()
     * @uses AddressRecord::setStreet3()
     * @uses AddressRecord::setStreet4()
     * @uses AddressRecord::setCity()
     * @uses AddressRecord::setStateProvince()
     * @uses AddressRecord::setPostalCode()
     * @uses AddressRecord::setCountry()
     * @param int $contact_Id
     * @param bool $active
     * @param bool $receiveMail
     * @param int $addressType_Id
     * @param int $addressClass_Id
     * @param bool $isPreferredMailing
     * @param bool $isPreferredShipping
     * @param int $seasonalMonthFrom
     * @param int $seasonalDayFrom
     * @param int $seasonalMonthTo
     * @param int $seasonalDayTo
     * @param float $latitude
     * @param float $longitude
     * @param string $street1
     * @param string $street2
     * @param string $street3
     * @param string $street4
     * @param string $city
     * @param \StructType\StateProvince $stateProvince
     * @param string $postalCode
     * @param \StructType\Country $country
     */
    public function __construct($contact_Id = null, $active = null, $receiveMail = null, $addressType_Id = null, $addressClass_Id = null, $isPreferredMailing = null, $isPreferredShipping = null, $seasonalMonthFrom = null, $seasonalDayFrom = null, $seasonalMonthTo = null, $seasonalDayTo = null, $latitude = null, $longitude = null, $street1 = null, $street2 = null, $street3 = null, $street4 = null, $city = null, \StructType\StateProvince $stateProvince = null, $postalCode = null, \StructType\Country $country = null)
    {
        $this
            ->setContact_Id($contact_Id)
            ->setActive($active)
            ->setReceiveMail($receiveMail)
            ->setAddressType_Id($addressType_Id)
            ->setAddressClass_Id($addressClass_Id)
            ->setIsPreferredMailing($isPreferredMailing)
            ->setIsPreferredShipping($isPreferredShipping)
            ->setSeasonalMonthFrom($seasonalMonthFrom)
            ->setSeasonalDayFrom($seasonalDayFrom)
            ->setSeasonalMonthTo($seasonalMonthTo)
            ->setSeasonalDayTo($seasonalDayTo)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setStreet1($street1)
            ->setStreet2($street2)
            ->setStreet3($street3)
            ->setStreet4($street4)
            ->setCity($city)
            ->setStateProvince($stateProvince)
            ->setPostalCode($postalCode)
            ->setCountry($country);
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\AddressRecord
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\AddressRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ReceiveMail value
     * @return bool
     */
    public function getReceiveMail()
    {
        return $this->ReceiveMail;
    }
    /**
     * Set ReceiveMail value
     * @param bool $receiveMail
     * @return \StructType\AddressRecord
     */
    public function setReceiveMail($receiveMail = null)
    {
        // validation for constraint: boolean
        if (!is_null($receiveMail) && !is_bool($receiveMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($receiveMail)), __LINE__);
        }
        $this->ReceiveMail = $receiveMail;
        return $this;
    }
    /**
     * Get AddressType_Id value
     * @return int
     */
    public function getAddressType_Id()
    {
        return $this->AddressType_Id;
    }
    /**
     * Set AddressType_Id value
     * @param int $addressType_Id
     * @return \StructType\AddressRecord
     */
    public function setAddressType_Id($addressType_Id = null)
    {
        // validation for constraint: int
        if (!is_null($addressType_Id) && !is_numeric($addressType_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($addressType_Id)), __LINE__);
        }
        $this->AddressType_Id = $addressType_Id;
        return $this;
    }
    /**
     * Get AddressClass_Id value
     * @return int
     */
    public function getAddressClass_Id()
    {
        return $this->AddressClass_Id;
    }
    /**
     * Set AddressClass_Id value
     * @param int $addressClass_Id
     * @return \StructType\AddressRecord
     */
    public function setAddressClass_Id($addressClass_Id = null)
    {
        // validation for constraint: int
        if (!is_null($addressClass_Id) && !is_numeric($addressClass_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($addressClass_Id)), __LINE__);
        }
        $this->AddressClass_Id = $addressClass_Id;
        return $this;
    }
    /**
     * Get IsPreferredMailing value
     * @return bool
     */
    public function getIsPreferredMailing()
    {
        return $this->IsPreferredMailing;
    }
    /**
     * Set IsPreferredMailing value
     * @param bool $isPreferredMailing
     * @return \StructType\AddressRecord
     */
    public function setIsPreferredMailing($isPreferredMailing = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPreferredMailing) && !is_bool($isPreferredMailing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPreferredMailing)), __LINE__);
        }
        $this->IsPreferredMailing = $isPreferredMailing;
        return $this;
    }
    /**
     * Get IsPreferredShipping value
     * @return bool
     */
    public function getIsPreferredShipping()
    {
        return $this->IsPreferredShipping;
    }
    /**
     * Set IsPreferredShipping value
     * @param bool $isPreferredShipping
     * @return \StructType\AddressRecord
     */
    public function setIsPreferredShipping($isPreferredShipping = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPreferredShipping) && !is_bool($isPreferredShipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPreferredShipping)), __LINE__);
        }
        $this->IsPreferredShipping = $isPreferredShipping;
        return $this;
    }
    /**
     * Get SeasonalMonthFrom value
     * @return int
     */
    public function getSeasonalMonthFrom()
    {
        return $this->SeasonalMonthFrom;
    }
    /**
     * Set SeasonalMonthFrom value
     * @param int $seasonalMonthFrom
     * @return \StructType\AddressRecord
     */
    public function setSeasonalMonthFrom($seasonalMonthFrom = null)
    {
        // validation for constraint: int
        if (!is_null($seasonalMonthFrom) && !is_numeric($seasonalMonthFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seasonalMonthFrom)), __LINE__);
        }
        $this->SeasonalMonthFrom = $seasonalMonthFrom;
        return $this;
    }
    /**
     * Get SeasonalDayFrom value
     * @return int
     */
    public function getSeasonalDayFrom()
    {
        return $this->SeasonalDayFrom;
    }
    /**
     * Set SeasonalDayFrom value
     * @param int $seasonalDayFrom
     * @return \StructType\AddressRecord
     */
    public function setSeasonalDayFrom($seasonalDayFrom = null)
    {
        // validation for constraint: int
        if (!is_null($seasonalDayFrom) && !is_numeric($seasonalDayFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seasonalDayFrom)), __LINE__);
        }
        $this->SeasonalDayFrom = $seasonalDayFrom;
        return $this;
    }
    /**
     * Get SeasonalMonthTo value
     * @return int
     */
    public function getSeasonalMonthTo()
    {
        return $this->SeasonalMonthTo;
    }
    /**
     * Set SeasonalMonthTo value
     * @param int $seasonalMonthTo
     * @return \StructType\AddressRecord
     */
    public function setSeasonalMonthTo($seasonalMonthTo = null)
    {
        // validation for constraint: int
        if (!is_null($seasonalMonthTo) && !is_numeric($seasonalMonthTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seasonalMonthTo)), __LINE__);
        }
        $this->SeasonalMonthTo = $seasonalMonthTo;
        return $this;
    }
    /**
     * Get SeasonalDayTo value
     * @return int
     */
    public function getSeasonalDayTo()
    {
        return $this->SeasonalDayTo;
    }
    /**
     * Set SeasonalDayTo value
     * @param int $seasonalDayTo
     * @return \StructType\AddressRecord
     */
    public function setSeasonalDayTo($seasonalDayTo = null)
    {
        // validation for constraint: int
        if (!is_null($seasonalDayTo) && !is_numeric($seasonalDayTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seasonalDayTo)), __LINE__);
        }
        $this->SeasonalDayTo = $seasonalDayTo;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\AddressRecord
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\AddressRecord
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Street1 value
     * @return string|null
     */
    public function getStreet1()
    {
        return $this->Street1;
    }
    /**
     * Set Street1 value
     * @param string $street1
     * @return \StructType\AddressRecord
     */
    public function setStreet1($street1 = null)
    {
        // validation for constraint: string
        if (!is_null($street1) && !is_string($street1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street1)), __LINE__);
        }
        $this->Street1 = $street1;
        return $this;
    }
    /**
     * Get Street2 value
     * @return string|null
     */
    public function getStreet2()
    {
        return $this->Street2;
    }
    /**
     * Set Street2 value
     * @param string $street2
     * @return \StructType\AddressRecord
     */
    public function setStreet2($street2 = null)
    {
        // validation for constraint: string
        if (!is_null($street2) && !is_string($street2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street2)), __LINE__);
        }
        $this->Street2 = $street2;
        return $this;
    }
    /**
     * Get Street3 value
     * @return string|null
     */
    public function getStreet3()
    {
        return $this->Street3;
    }
    /**
     * Set Street3 value
     * @param string $street3
     * @return \StructType\AddressRecord
     */
    public function setStreet3($street3 = null)
    {
        // validation for constraint: string
        if (!is_null($street3) && !is_string($street3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street3)), __LINE__);
        }
        $this->Street3 = $street3;
        return $this;
    }
    /**
     * Get Street4 value
     * @return string|null
     */
    public function getStreet4()
    {
        return $this->Street4;
    }
    /**
     * Set Street4 value
     * @param string $street4
     * @return \StructType\AddressRecord
     */
    public function setStreet4($street4 = null)
    {
        // validation for constraint: string
        if (!is_null($street4) && !is_string($street4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street4)), __LINE__);
        }
        $this->Street4 = $street4;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\AddressRecord
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateProvince value
     * @return \StructType\StateProvince|null
     */
    public function getStateProvince()
    {
        return $this->StateProvince;
    }
    /**
     * Set StateProvince value
     * @param \StructType\StateProvince $stateProvince
     * @return \StructType\AddressRecord
     */
    public function setStateProvince(\StructType\StateProvince $stateProvince = null)
    {
        $this->StateProvince = $stateProvince;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\AddressRecord
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\Country|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\Country $country
     * @return \StructType\AddressRecord
     */
    public function setCountry(\StructType\Country $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
