<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityRecord StructType
 * @subpackage Structs
 */
class ActivityRecord extends DataRecord
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The CreatedByContact_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $CreatedByContact_Id;
    /**
     * The ParticipatingContactCount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ParticipatingContactCount;
    /**
     * The AssignedContactCount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $AssignedContactCount;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityType
     */
    public $Type;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityStatus
     */
    public $Status;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Location;
    /**
     * The FirstParticipatingContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $FirstParticipatingContact;
    /**
     * The FirstAssignedContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $FirstAssignedContact;
    /**
     * The ParticipatingContacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfContactSummary
     */
    public $ParticipatingContacts;
    /**
     * The AssignedContacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfContactSummary
     */
    public $AssignedContacts;
    /**
     * Constructor method for ActivityRecord
     * @uses ActivityRecord::setStartDate()
     * @uses ActivityRecord::setEndDate()
     * @uses ActivityRecord::setCreatedByContact_Id()
     * @uses ActivityRecord::setParticipatingContactCount()
     * @uses ActivityRecord::setAssignedContactCount()
     * @uses ActivityRecord::setType()
     * @uses ActivityRecord::setStatus()
     * @uses ActivityRecord::setTitle()
     * @uses ActivityRecord::setLocation()
     * @uses ActivityRecord::setFirstParticipatingContact()
     * @uses ActivityRecord::setFirstAssignedContact()
     * @uses ActivityRecord::setParticipatingContacts()
     * @uses ActivityRecord::setAssignedContacts()
     * @param string $startDate
     * @param string $endDate
     * @param int $createdByContact_Id
     * @param int $participatingContactCount
     * @param int $assignedContactCount
     * @param \StructType\ActivityType $type
     * @param \StructType\ActivityStatus $status
     * @param string $title
     * @param string $location
     * @param \StructType\ContactSummary $firstParticipatingContact
     * @param \StructType\ContactSummary $firstAssignedContact
     * @param \ArrayType\ArrayOfContactSummary $participatingContacts
     * @param \ArrayType\ArrayOfContactSummary $assignedContacts
     */
    public function __construct($startDate = null, $endDate = null, $createdByContact_Id = null, $participatingContactCount = null, $assignedContactCount = null, \StructType\ActivityType $type = null, \StructType\ActivityStatus $status = null, $title = null, $location = null, \StructType\ContactSummary $firstParticipatingContact = null, \StructType\ContactSummary $firstAssignedContact = null, \ArrayType\ArrayOfContactSummary $participatingContacts = null, \ArrayType\ArrayOfContactSummary $assignedContacts = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setCreatedByContact_Id($createdByContact_Id)
            ->setParticipatingContactCount($participatingContactCount)
            ->setAssignedContactCount($assignedContactCount)
            ->setType($type)
            ->setStatus($status)
            ->setTitle($title)
            ->setLocation($location)
            ->setFirstParticipatingContact($firstParticipatingContact)
            ->setFirstAssignedContact($firstAssignedContact)
            ->setParticipatingContacts($participatingContacts)
            ->setAssignedContacts($assignedContacts);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\ActivityRecord
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ActivityRecord
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get CreatedByContact_Id value
     * @return int
     */
    public function getCreatedByContact_Id()
    {
        return $this->CreatedByContact_Id;
    }
    /**
     * Set CreatedByContact_Id value
     * @param int $createdByContact_Id
     * @return \StructType\ActivityRecord
     */
    public function setCreatedByContact_Id($createdByContact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($createdByContact_Id) && !is_numeric($createdByContact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createdByContact_Id)), __LINE__);
        }
        $this->CreatedByContact_Id = $createdByContact_Id;
        return $this;
    }
    /**
     * Get ParticipatingContactCount value
     * @return int
     */
    public function getParticipatingContactCount()
    {
        return $this->ParticipatingContactCount;
    }
    /**
     * Set ParticipatingContactCount value
     * @param int $participatingContactCount
     * @return \StructType\ActivityRecord
     */
    public function setParticipatingContactCount($participatingContactCount = null)
    {
        // validation for constraint: int
        if (!is_null($participatingContactCount) && !is_numeric($participatingContactCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($participatingContactCount)), __LINE__);
        }
        $this->ParticipatingContactCount = $participatingContactCount;
        return $this;
    }
    /**
     * Get AssignedContactCount value
     * @return int
     */
    public function getAssignedContactCount()
    {
        return $this->AssignedContactCount;
    }
    /**
     * Set AssignedContactCount value
     * @param int $assignedContactCount
     * @return \StructType\ActivityRecord
     */
    public function setAssignedContactCount($assignedContactCount = null)
    {
        // validation for constraint: int
        if (!is_null($assignedContactCount) && !is_numeric($assignedContactCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($assignedContactCount)), __LINE__);
        }
        $this->AssignedContactCount = $assignedContactCount;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\ActivityType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\ActivityType $type
     * @return \StructType\ActivityRecord
     */
    public function setType(\StructType\ActivityType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\ActivityStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\ActivityStatus $status
     * @return \StructType\ActivityRecord
     */
    public function setStatus(\StructType\ActivityStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\ActivityRecord
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\ActivityRecord
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get FirstParticipatingContact value
     * @return \StructType\ContactSummary|null
     */
    public function getFirstParticipatingContact()
    {
        return $this->FirstParticipatingContact;
    }
    /**
     * Set FirstParticipatingContact value
     * @param \StructType\ContactSummary $firstParticipatingContact
     * @return \StructType\ActivityRecord
     */
    public function setFirstParticipatingContact(\StructType\ContactSummary $firstParticipatingContact = null)
    {
        $this->FirstParticipatingContact = $firstParticipatingContact;
        return $this;
    }
    /**
     * Get FirstAssignedContact value
     * @return \StructType\ContactSummary|null
     */
    public function getFirstAssignedContact()
    {
        return $this->FirstAssignedContact;
    }
    /**
     * Set FirstAssignedContact value
     * @param \StructType\ContactSummary $firstAssignedContact
     * @return \StructType\ActivityRecord
     */
    public function setFirstAssignedContact(\StructType\ContactSummary $firstAssignedContact = null)
    {
        $this->FirstAssignedContact = $firstAssignedContact;
        return $this;
    }
    /**
     * Get ParticipatingContacts value
     * @return \ArrayType\ArrayOfContactSummary|null
     */
    public function getParticipatingContacts()
    {
        return $this->ParticipatingContacts;
    }
    /**
     * Set ParticipatingContacts value
     * @param \ArrayType\ArrayOfContactSummary $participatingContacts
     * @return \StructType\ActivityRecord
     */
    public function setParticipatingContacts(\ArrayType\ArrayOfContactSummary $participatingContacts = null)
    {
        $this->ParticipatingContacts = $participatingContacts;
        return $this;
    }
    /**
     * Get AssignedContacts value
     * @return \ArrayType\ArrayOfContactSummary|null
     */
    public function getAssignedContacts()
    {
        return $this->AssignedContacts;
    }
    /**
     * Set AssignedContacts value
     * @param \ArrayType\ArrayOfContactSummary $assignedContacts
     * @return \StructType\ActivityRecord
     */
    public function setAssignedContacts(\ArrayType\ArrayOfContactSummary $assignedContacts = null)
    {
        $this->AssignedContacts = $assignedContacts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
