<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProcessAchPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessAchPayments $parameters
     * @return \StructType\ProcessAchPaymentsResponse|bool
     */
    public function ProcessAchPayments(\StructType\ProcessAchPayments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessAchPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessAchPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessAchPayment $parameters
     * @return \StructType\ProcessAchPaymentResponse|bool
     */
    public function ProcessAchPayment(\StructType\ProcessAchPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessAchPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessECheckPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessECheckPayments $parameters
     * @return \StructType\ProcessECheckPaymentsResponse|bool
     */
    public function ProcessECheckPayments(\StructType\ProcessECheckPayments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessECheckPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessECheckPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessECheckPayment $parameters
     * @return \StructType\ProcessECheckPaymentResponse|bool
     */
    public function ProcessECheckPayment(\StructType\ProcessECheckPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessECheckPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProcessAchPaymentResponse|\StructType\ProcessAchPaymentsResponse|\StructType\ProcessECheckPaymentResponse|\StructType\ProcessECheckPaymentsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
