<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authorize ServiceType
 * @subpackage Services
 */
class Authorize extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AuthorizeCreditCards
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthorizeCreditCards $parameters
     * @return \StructType\AuthorizeCreditCardsResponse|bool
     */
    public function AuthorizeCreditCards(\StructType\AuthorizeCreditCards $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AuthorizeCreditCards($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AuthorizeCreditCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthorizeCreditCard $parameters
     * @return \StructType\AuthorizeCreditCardResponse|bool
     */
    public function AuthorizeCreditCard(\StructType\AuthorizeCreditCard $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AuthorizeCreditCard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AuthorizeCreditCardResponse|\StructType\AuthorizeCreditCardsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
