<?php

namespace EnumType;

/**
 * This class stands for SustainerFrequencies EnumType
 * @subpackage Enumerations
 */
class SustainerFrequencies
{
    /**
     * Constant for value 'Daily'
     * @return string 'Daily'
     */
    const VALUE_DAILY = 'Daily';
    /**
     * Constant for value 'Weekly'
     * @return string 'Weekly'
     */
    const VALUE_WEEKLY = 'Weekly';
    /**
     * Constant for value 'BiMonthly'
     * @return string 'BiMonthly'
     */
    const VALUE_BI_MONTHLY = 'BiMonthly';
    /**
     * Constant for value 'Monthly'
     * @return string 'Monthly'
     */
    const VALUE_MONTHLY = 'Monthly';
    /**
     * Constant for value 'Quarterly'
     * @return string 'Quarterly'
     */
    const VALUE_QUARTERLY = 'Quarterly';
    /**
     * Constant for value 'BiAnnually'
     * @return string 'BiAnnually'
     */
    const VALUE_BI_ANNUALLY = 'BiAnnually';
    /**
     * Constant for value 'Annually'
     * @return string 'Annually'
     */
    const VALUE_ANNUALLY = 'Annually';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DAILY
     * @uses self::VALUE_WEEKLY
     * @uses self::VALUE_BI_MONTHLY
     * @uses self::VALUE_MONTHLY
     * @uses self::VALUE_QUARTERLY
     * @uses self::VALUE_BI_ANNUALLY
     * @uses self::VALUE_ANNUALLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DAILY,
            self::VALUE_WEEKLY,
            self::VALUE_BI_MONTHLY,
            self::VALUE_MONTHLY,
            self::VALUE_QUARTERLY,
            self::VALUE_BI_ANNUALLY,
            self::VALUE_ANNUALLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
