<?php

namespace EnumType;

/**
 * This class stands for SalutationTypes EnumType
 * @subpackage Enumerations
 */
class SalutationTypes
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'Formal'
     * @return string 'Formal'
     */
    const VALUE_FORMAL = 'Formal';
    /**
     * Constant for value 'Informal'
     * @return string 'Informal'
     */
    const VALUE_INFORMAL = 'Informal';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_FORMAL
     * @uses self::VALUE_INFORMAL
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_FORMAL,
            self::VALUE_INFORMAL,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
