<?php

namespace EnumType;

/**
 * This class stands for IntegrationApiErrorCodes EnumType
 * @subpackage Enumerations
 */
class IntegrationApiErrorCodes
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'AuthenticationFailed'
     * @return string 'AuthenticationFailed'
     */
    const VALUE_AUTHENTICATION_FAILED = 'AuthenticationFailed';
    /**
     * Constant for value 'InvalidParameters'
     * @return string 'InvalidParameters'
     */
    const VALUE_INVALID_PARAMETERS = 'InvalidParameters';
    /**
     * Constant for value 'IdRequiredForChangeOperations'
     * @return string 'IdRequiredForChangeOperations'
     */
    const VALUE_ID_REQUIRED_FOR_CHANGE_OPERATIONS = 'IdRequiredForChangeOperations';
    /**
     * Constant for value 'MultiStepDependencyError'
     * @return string 'MultiStepDependencyError'
     */
    const VALUE_MULTI_STEP_DEPENDENCY_ERROR = 'MultiStepDependencyError';
    /**
     * Constant for value 'CoreRecordCreationError'
     * @return string 'CoreRecordCreationError'
     */
    const VALUE_CORE_RECORD_CREATION_ERROR = 'CoreRecordCreationError';
    /**
     * Constant for value 'FatalError'
     * @return string 'FatalError'
     */
    const VALUE_FATAL_ERROR = 'FatalError';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_AUTHENTICATION_FAILED
     * @uses self::VALUE_INVALID_PARAMETERS
     * @uses self::VALUE_ID_REQUIRED_FOR_CHANGE_OPERATIONS
     * @uses self::VALUE_MULTI_STEP_DEPENDENCY_ERROR
     * @uses self::VALUE_CORE_RECORD_CREATION_ERROR
     * @uses self::VALUE_FATAL_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_AUTHENTICATION_FAILED,
            self::VALUE_INVALID_PARAMETERS,
            self::VALUE_ID_REQUIRED_FOR_CHANGE_OPERATIONS,
            self::VALUE_MULTI_STEP_DEPENDENCY_ERROR,
            self::VALUE_CORE_RECORD_CREATION_ERROR,
            self::VALUE_FATAL_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
