<?php

namespace EnumType;

/**
 * This class stands for InitiativeMessageReturnTypes EnumType
 * @subpackage Enumerations
 */
class InitiativeMessageReturnTypes
{
    /**
     * Constant for value 'Blocked'
     * @return string 'Blocked'
     */
    const VALUE_BLOCKED = 'Blocked';
    /**
     * Constant for value 'Custom'
     * @return string 'Custom'
     */
    const VALUE_CUSTOM = 'Custom';
    /**
     * Constant for value 'Informational'
     * @return string 'Informational'
     */
    const VALUE_INFORMATIONAL = 'Informational';
    /**
     * Constant for value 'Undeliverable'
     * @return string 'Undeliverable'
     */
    const VALUE_UNDELIVERABLE = 'Undeliverable';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BLOCKED
     * @uses self::VALUE_CUSTOM
     * @uses self::VALUE_INFORMATIONAL
     * @uses self::VALUE_UNDELIVERABLE
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BLOCKED,
            self::VALUE_CUSTOM,
            self::VALUE_INFORMATIONAL,
            self::VALUE_UNDELIVERABLE,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
