<?php

namespace EnumType;

/**
 * This class stands for InitiativeConversionTypes EnumType
 * @subpackage Enumerations
 */
class InitiativeConversionTypes
{
    /**
     * Constant for value 'EcommerceOrder'
     * @return string 'EcommerceOrder'
     */
    const VALUE_ECOMMERCE_ORDER = 'EcommerceOrder';
    /**
     * Constant for value 'WebFormTransaction'
     * @return string 'WebFormTransaction'
     */
    const VALUE_WEB_FORM_TRANSACTION = 'WebFormTransaction';
    /**
     * Constant for value 'WebFormSustainer'
     * @return string 'WebFormSustainer'
     */
    const VALUE_WEB_FORM_SUSTAINER = 'WebFormSustainer';
    /**
     * Constant for value 'AdvocacyAction'
     * @return string 'AdvocacyAction'
     */
    const VALUE_ADVOCACY_ACTION = 'AdvocacyAction';
    /**
     * Constant for value 'ListSignup'
     * @return string 'ListSignup'
     */
    const VALUE_LIST_SIGNUP = 'ListSignup';
    /**
     * Constant for value 'SustainerReactivation'
     * @return string 'SustainerReactivation'
     */
    const VALUE_SUSTAINER_REACTIVATION = 'SustainerReactivation';
    /**
     * Constant for value 'PeerToPeerDonation'
     * @return string 'PeerToPeerDonation'
     */
    const VALUE_PEER_TO_PEER_DONATION = 'PeerToPeerDonation';
    /**
     * Constant for value 'PeerToPeerRegistration'
     * @return string 'PeerToPeerRegistration'
     */
    const VALUE_PEER_TO_PEER_REGISTRATION = 'PeerToPeerRegistration';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ECOMMERCE_ORDER
     * @uses self::VALUE_WEB_FORM_TRANSACTION
     * @uses self::VALUE_WEB_FORM_SUSTAINER
     * @uses self::VALUE_ADVOCACY_ACTION
     * @uses self::VALUE_LIST_SIGNUP
     * @uses self::VALUE_SUSTAINER_REACTIVATION
     * @uses self::VALUE_PEER_TO_PEER_DONATION
     * @uses self::VALUE_PEER_TO_PEER_REGISTRATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ECOMMERCE_ORDER,
            self::VALUE_WEB_FORM_TRANSACTION,
            self::VALUE_WEB_FORM_SUSTAINER,
            self::VALUE_ADVOCACY_ACTION,
            self::VALUE_LIST_SIGNUP,
            self::VALUE_SUSTAINER_REACTIVATION,
            self::VALUE_PEER_TO_PEER_DONATION,
            self::VALUE_PEER_TO_PEER_REGISTRATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
