<?php

namespace EnumType;

/**
 * This class stands for CreateSustainerPaymentModes EnumType
 * @subpackage Enumerations
 */
class CreateSustainerPaymentModes
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'AuthorizeFormOfPayment'
     * @return string 'AuthorizeFormOfPayment'
     */
    const VALUE_AUTHORIZE_FORM_OF_PAYMENT = 'AuthorizeFormOfPayment';
    /**
     * Constant for value 'ProcessFirstPayment'
     * @return string 'ProcessFirstPayment'
     */
    const VALUE_PROCESS_FIRST_PAYMENT = 'ProcessFirstPayment';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_AUTHORIZE_FORM_OF_PAYMENT
     * @uses self::VALUE_PROCESS_FIRST_PAYMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_AUTHORIZE_FORM_OF_PAYMENT,
            self::VALUE_PROCESS_FIRST_PAYMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
