<?php

namespace EnumType;

/**
 * This class stands for ContactTypes EnumType
 * @subpackage Enumerations
 */
class ContactTypes
{
    /**
     * Constant for value 'Organization'
     * @return string 'Organization'
     */
    const VALUE_ORGANIZATION = 'Organization';
    /**
     * Constant for value 'Person'
     * @return string 'Person'
     */
    const VALUE_PERSON = 'Person';
    /**
     * Constant for value 'Household'
     * @return string 'Household'
     */
    const VALUE_HOUSEHOLD = 'Household';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ORGANIZATION
     * @uses self::VALUE_PERSON
     * @uses self::VALUE_HOUSEHOLD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ORGANIZATION,
            self::VALUE_PERSON,
            self::VALUE_HOUSEHOLD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
